/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.task;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.ContextNullException;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.ClientVersionStorage;
import com.xdja.upgrade.storage.RXDStorage;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.task.RxdApkSocket;
import com.xdja.upgrade.task.SocketService;
import com.xdja.upgrade.task.UpdateModuleTask;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.ui.ProgressDialogWrapper;
import com.xdja.upgrade.util.AlgUtil;
import com.xdja.upgrade.util.AppUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class RxdApkTask
extends UpdateModuleTask<String, Integer, Integer> {
    Context context;
    RXDConfig rxdConfig;
    ClientVersion clientVersion;
    RxdApkSocket socketService;
    List<com.xdja.upgrade.bean.update_s_bean.File> filesList;
    ProgressDialogWrapper progressDialogWrapper;

    @Override
    public void template() throws ContextNullException {
        if (this.context == null) {
            throw new ContextNullException();
        }
        this.progressDialogWrapper = new ProgressDialogWrapper(this.context).setIsForceUpdate(this.rxdConfig.isForceUpdate());
        this.execute(new String[0]);
    }

    public RxdApkTask(Context context, RXDConfig rxdConfig) throws UpdateModuleException {
        super(context);
        this.context = context;
        this.rxdConfig = rxdConfig;
        this.filesList = rxdConfig.getUpdate().getFiles().getFiles();
        this.clientVersion = new ClientVersionStorage(context).read(context);
        this.socketService = new RxdApkSocket(context, this.clientVersion).setRXDConfig(rxdConfig);
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.progressDialogWrapper.showDownloading();
    }

    protected Integer doInBackground(String ... strings) {
        if (this.filesList.isEmpty()) {
            RXDStorage.deleteDefaultXml(this.context);
            return -122;
        }
        int fileSum = this.filesList.size();
        for (int i = 0; i < fileSum; ++i) {
            com.xdja.upgrade.bean.update_s_bean.File updateServerFile = this.filesList.get(i);
            if (updateServerFile.getDownloadSize() == updateServerFile.getFileSize()) {
                return this.validateLocalFile(updateServerFile);
            }
            if (updateServerFile.getDownloadSize() >= updateServerFile.getFileSize()) continue;
            File file = new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName());
            if (file.exists() && file.length() != updateServerFile.getDownloadSize()) {
                updateServerFile.setDownloadSize(file.length());
            }
            this.socketService.setUpdateServerFile(updateServerFile);
            SocketService.SocketResult socketResult = this.socketService.executeSocket();
            if (socketResult.getResultCode() != 0) {
                try {
                    RXDStorage.writeDefaultXml(this.context, this.rxdConfig);
                }
                catch (Exception e) {
                    return -1;
                }
            } else {
                return this.writeApkFile(updateServerFile);
            }
            return socketResult.getResultCode();
        }
        return 0;
    }

    @Override
    protected void onPostExecute(Integer result) {
        super.onPostExecute(result);
        this.progressDialogWrapper.dismiss();
        this.socketService.close();
        if (result != 0) {
            AlertDialogWrapper.downloadFailureDialog(this.context);
        } else {
            for (com.xdja.upgrade.bean.update_s_bean.File updateServerFile : this.filesList) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setFlags(0x10000000);
                intent.setDataAndType(Uri.fromFile((File)new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName())), "application/vnd.android.package-archive");
                this.context.startActivity(intent);
            }
        }
        try {
            this.processRemainedFiles(this.context);
        }
        catch (Exception e) {
            new UpdateModuleException(e);
        }
    }

    private int validateLocalFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        File file = new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName());
        if (file.exists()) {
            try {
                String md5Hash = AlgUtil.getMD5Hash(file);
                if (!md5Hash.equals(updateServerFile.getCheckCode())) {
                    file.delete();
                    return -116;
                }
                return 0;
            }
            catch (Exception e) {
                return -116;
            }
        }
        StorageIO.deleteRxdConfig(this.context);
        return -117;
    }

    private int writeApkFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        File downloadingFile = new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName());
        int fileSize = (int)updateServerFile.getFileSize();
        int downloadedSize = (int)updateServerFile.getDownloadSize();
        String fileName = updateServerFile.getFileName();
        while (downloadedSize < fileSize) {
            int bucket = fileSize - downloadedSize;
            byte[] data = new byte[bucket];
            try {
                int currentLen = this.socketService.read(data, 0, bucket);
                if (currentLen == -1) {
                    RXDStorage.writeDefaultXml(this.context, this.rxdConfig);
                    return -114;
                }
                try {
                    this.publishProgress(new Integer[]{(int)((float)(downloadedSize += currentLen) / (float)fileSize * 100.0f)});
                    StorageIO.writeFileAppend(AppUtil.getAppAbsolutePath(this.context) + "/" + fileName, data, currentLen);
                    Runtime.getRuntime().exec("chmod 644 " + AppUtil.getAppAbsolutePath(this.context) + "/" + fileName);
                    if (downloadedSize >= fileSize) {
                        updateServerFile.setState("2");
                        RXDStorage.writeDefaultXml(this.context, this.rxdConfig);
                        String md5Hash = AlgUtil.getMD5Hash(AppUtil.getAppAbsolutePath(this.context) + "/" + fileName);
                        if (md5Hash.equals(updateServerFile.getCheckCode())) continue;
                        downloadingFile.delete();
                        return -116;
                    }
                    updateServerFile.setState("1");
                    RXDStorage.writeDefaultXml(this.context, this.rxdConfig);
                }
                catch (Exception e) {
                    downloadingFile.delete();
                    updateServerFile.setState("0");
                    updateServerFile.setDownloadSize(0L);
                    RXDStorage.writeDefaultXml(this.context, this.rxdConfig);
                    return -115;
                }
            }
            catch (Exception e) {
                return -114;
            }
        }
        return 0;
    }

    private void processRemainedFiles(Context context) throws Exception {
        File file = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        file.delete();
        String versionName = AppUtil.getCurrentVersion(context);
        if (!versionName.equals(this.clientVersion.getVer().getVersion())) {
            this.clientVersion.getVer().setVersion(versionName);
            File localVersion = new File(AppUtil.getAppAbsolutePath(context) + "/ClientVer.xml");
            FileOutputStream outputStream = new FileOutputStream(localVersion);
            new ClientVersionStorage(context).write(context, this.clientVersion, (OutputStream)outputStream);
        }
    }
}

