/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.task;

import com.xdja.upgrade.NetWorkUtil;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.util.UpdateConfigConst;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public abstract class SocketService {
    public static final String TAG = SocketService.class.getName();
    protected ClientVersion clientVersion;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public SocketService(ClientVersion clientVersion) {
        UpdateLog.d(TAG, "SocketService\u6784\u9020\u51fd\u6570\u4e2d\u7684version");
        UpdateLog.d(TAG, clientVersion.toString());
        this.clientVersion = clientVersion;
    }

    public SocketResult executeSocket() {
        UpdateLog.d(TAG, "IP\u5408\u6cd5\u6027\u5224\u65ad");
        if (this.clientVersion.getIp().equals("")) {
            UpdateLog.d(TAG, "IP\u672a\u8bbe\u7f6e");
            return new SocketResult(-102);
        }
        UpdateLog.d(TAG, "\u7aef\u53e3\u5408\u6cd5\u6027\u5224\u65ad");
        if (this.clientVersion.getPort().equals("")) {
            UpdateLog.d(TAG, "\u7aef\u53e3\u672a\u8bbe\u7f6e");
            return new SocketResult(-103);
        }
        UpdateLog.d(TAG, "\u57df\u540d\u89e3\u6790");
        String hostIP = NetWorkUtil.getHostAddress(this.clientVersion.getIp());
        if (hostIP == null) {
            UpdateLog.d(TAG, "IP\u89e3\u6790\u9519\u8bef");
            return new SocketResult(-104);
        }
        UpdateLog.d(TAG, "\u8fde\u63a5\u670d\u52a1\u5668");
        int connectServerResult = this.connectServer();
        UpdateLog.d(TAG, "\u8fde\u63a5\u5f02\u5e38\u5224\u65ad");
        if (connectServerResult == -1) {
            UpdateLog.d(TAG, "\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38");
            return new SocketResult(-105);
        }
        int requestHeadResult = this.sendRequestHead(this.getHeader());
        if (requestHeadResult == -1) {
            return new SocketResult(-106);
        }
        UpdateLog.d(TAG, "\u63a5\u6536\u8fd4\u56de\u6570\u636e");
        byte[] dataArray = this.recvData();
        UpdateLog.d(TAG, "\u8bfb\u53d6\u8fd4\u56de\u6570\u636e\u5f02\u5e38\u5224\u65ad");
        if (dataArray == null) {
            UpdateLog.d(TAG, "\u8bfb\u53d6\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
            return new SocketResult(-107);
        }
        UpdateLog.d(TAG, "\u8bfb\u53d6\u8fd4\u56de\u6570\u636e\u6b63\u5e38");
        return this.parseResponseHeader(dataArray);
    }

    protected abstract String getHeader();

    protected abstract SocketResult parseResponseHeader(byte[] var1);

    protected int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.inputStream.read(buffer, byteOffset, byteCount);
    }

    int connectServer() {
        try {
            this.socket = new Socket(this.clientVersion.getIp(), Integer.parseInt(this.clientVersion.getPort()));
            this.socket.setSoTimeout(this.clientVersion.getTimeOut());
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            e.getMessage();
            return -1;
        }
        return 0;
    }

    int sendRequestHead(String header) {
        UpdateLog.d(TAG, "\u53d1\u9001\u8bf7\u6c42\u5934" + header.toString());
        try {
            UpdateLog.d(TAG, "\u8bf7\u6c42\u5f02\u5e38\u5224\u65ad");
            int dataLen = header.getBytes().length;
            byte[] data = new byte[dataLen + 2];
            data[0] = (byte)(dataLen >> 8 & 0xFF);
            data[1] = (byte)(dataLen & 0xFF);
            System.arraycopy(header.getBytes(), 0, data, 2, dataLen);
            this.outputStream.write(data);
            this.outputStream.flush();
            UpdateLog.d(TAG, "\u8bf7\u6c42\u6b63\u5e38");
            return 0;
        }
        catch (Exception e) {
            UpdateLog.d(TAG, "\u8bf7\u6c42\u5f02\u5e38");
            e.getStackTrace();
            return -1;
        }
    }

    byte[] recvData() {
        try {
            byte[] data = null;
            int dataLen = 0;
            int currentLen = 0;
            int tempLen = 0;
            int headLen = 0;
            byte[] len = new byte[2];
            while (tempLen != -1 && (headLen += tempLen) < 2) {
                tempLen = this.inputStream.read(len, headLen, 2 - headLen);
            }
            if (tempLen == -1) {
                return null;
            }
            dataLen = this.bytes2Int(len);
            data = new byte[dataLen];
            tempLen = 0;
            while (tempLen != -1 && (currentLen += tempLen) < dataLen) {
                tempLen = this.inputStream.read(data, currentLen, dataLen - currentLen);
            }
            if (tempLen == -1) {
                return null;
            }
            return data;
        }
        catch (IOException e) {
            e.getStackTrace();
            return null;
        }
    }

    int bytes2Int(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 2; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getResultMessage(int resultCode) {
        return UpdateConfigConst.ConfigWrapper.getErrorDescription(resultCode);
    }

    public class SocketResult {
        private int resultCode;
        private byte[] resultBytes;

        public SocketResult(int resultCode) {
            this(resultCode, null);
        }

        public SocketResult(int resultCode, byte[] bytes) {
            this.resultCode = resultCode;
            this.resultBytes = bytes;
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public byte[] getResultBytes() {
            return this.resultBytes;
        }
    }
}

