/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.task;

import android.content.Context;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.UpgradeSettingCallback;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.task.ClientVersionSocket;
import com.xdja.upgrade.task.CommonTask;
import com.xdja.upgrade.task.SocketService;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.TaskManager;
import com.xdja.upgrade.util.UpdateConfigConst;
import com.xdja.upgrade.util.UpdateToast;

public class VersionCheckTask
extends CommonTask<String, Integer, Integer> {
    public static final String TAG = VersionCheckTask.class.getName();
    boolean alreadyRunning;
    UpgradeSettingCallback settingCallback;

    public VersionCheckTask(Context context) {
        super(context);
        this.progress.setIsShowLoading(true);
        this.alreadyRunning = TaskManager.isCheckRunning();
        UpdateLog.d(TAG, "alreadyRunning:" + this.alreadyRunning);
        if (!this.alreadyRunning) {
            TaskManager.setCheckRunning(true);
        }
    }

    public VersionCheckTask(Context context, UpgradeSettingCallback callback) {
        this(context);
        this.settingCallback = callback;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        if (this.alreadyRunning) {
            this.onPostExecute(TASK_IS_RUNNING);
        }
        this.progress.showLoading();
    }

    @Override
    public String getTaskName() {
        return VersionCheckTask.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground(String ... params) {
        Integer n;
        boolean writeSuccess;
        block10: {
            SocketService socketService = null;
            writeSuccess = false;
            try {
                UpdateLog.d(TAG, "\u8bfb\u53d6ip\u548c\u7aef\u53e3\u53f7");
                ClientVersion version = this.settingCallback != null ? this.settingCallback.getDefineBean() : StorageIO.readClientVersion(this.context);
                if (version != null) {
                    UpdateLog.d(TAG, "\u5f53\u524d\u914d\u7f6e\u4fe1\u606f", version.toString());
                } else {
                    UpdateLog.d(TAG, "\u914d\u7f6e\u4e3a\u7a7a", String.valueOf(version == null));
                }
                UpdateLog.d(TAG, "\u8bfb\u53d6\u5df2\u5b89\u88c5\u7684\u5305\u7684\u7248\u672c\u53f7");
                String installedVersion = AppUtil.getCurrentVersion(this.context);
                UpdateLog.d(TAG, "\u7248\u672c\u53f7\u4e3a\u7a7a" + String.valueOf(installedVersion == null), "\u5f53\u524d\u7248\u672c\u53f7\uff1a", installedVersion);
                UpdateLog.d(TAG, "\u542f\u52a8Socket\u8fde\u63a5");
                socketService = new ClientVersionSocket(version);
                SocketService.SocketResult result = socketService.executeSocket();
                if (result.getResultCode() == -100) {
                    UpdateLog.d(TAG, "\u5220\u9664update_temp.xml");
                    boolean deleteSuccess = StorageIO.deleteUpdateTemp(this.context);
                    UpdateLog.d(TAG, "\u5220\u9664\u7ed3\u679c\uff1a" + deleteSuccess);
                    UpdateLog.d(TAG, "update_s.xml\u662f\u5426\u5b58\u5728");
                    if (StorageIO.isUpdateSExist(this.context)) {
                        UpdateLog.d(TAG, "\u5b58\u5728\uff0csocket\u6570\u636e\u5199\u5165update_temp.xml");
                        StorageIO.writeUpdateTemp(this.context, result.getResultBytes());
                    } else {
                        UpdateLog.d(TAG, "\u4e0d\u5b58\u5728,Socket\u6570\u636e\u5199\u5165update_s.xml");
                        StorageIO.writeUpdateS(this.context, result.getResultBytes());
                    }
                    UpdateLog.d(TAG, "\u5199\u5165\u6587\u4ef6\u6b63\u5e38");
                    writeSuccess = true;
                }
                n = result.getResultCode();
                if (socketService == null) break block10;
            }
            catch (UpdateModuleException e) {
                Integer n2;
                block11: {
                    try {
                        writeSuccess = false;
                        n2 = -101;
                        if (socketService == null) break block11;
                        socketService.close();
                    }
                    catch (Throwable throwable) {
                        if (socketService != null) {
                            socketService.close();
                        }
                        UpdateLog.d(TAG, "\u662f\u5426\u5199\u5165\u6570\u636e\u5f02\u5e38\uff1a" + writeSuccess);
                        throw throwable;
                    }
                }
                UpdateLog.d(TAG, "\u662f\u5426\u5199\u5165\u6570\u636e\u5f02\u5e38\uff1a" + writeSuccess);
                return n2;
            }
            socketService.close();
        }
        UpdateLog.d(TAG, "\u662f\u5426\u5199\u5165\u6570\u636e\u5f02\u5e38\uff1a" + writeSuccess);
        return n;
    }

    protected void onPostExecute(Integer resultCode) {
        super.onPostExecute((Object)resultCode);
        this.progress.dismiss();
        if (resultCode == TASK_IS_RUNNING) {
            UpdateLog.d("alreadyRunning", "\u68c0\u6d4b\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d");
        } else {
            UpdateLog.d(TAG, "\u6267\u884c\u7ed3\u679c" + resultCode);
            try {
                if (resultCode == -100) {
                    UpdateLog.d(TAG, "\u8bfb\u53d6\u672c\u5730\u83b7\u53d6\u5230\u7684\u5347\u7ea7\u6587\u4ef6update_s.xml \u6216update_temp.xml");
                    RXDConfig rxdConfig = StorageIO.readRxdConfig(this.context);
                    UpdateLog.d(TAG, "\u8bfb\u53d6\u5230\u7684\u914d\u7f6e\u4fe1\u606f", rxdConfig.toString());
                    UpdateLog.d("alreadyRunning", "\u5f39\u51fa\u5bf9\u8bdd\u6846");
                    AlertDialogWrapper dialog = new AlertDialogWrapper(this.context, true);
                    if (this.settingCallback != null) {
                        dialog.showDialog(rxdConfig, this.settingCallback.getDefineBean());
                    } else {
                        dialog.showDialog(rxdConfig);
                    }
                } else {
                    UpdateLog.d(TAG, "socket\u6d41\u7a0b\u5f02\u5e38");
                    UpdateToast.show(this.context, UpdateConfigConst.ConfigWrapper.getErrorDescription(resultCode));
                }
            }
            catch (UpdateModuleException e) {
                e.printStackTrace();
            }
        }
    }
}

