/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.xdja.upgrade.R;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.receiver.UpdateReceiver;
import com.xdja.upgrade.task.DownloadApkTask;
import com.xdja.upgrade.util.TaskManager;

public class AlertDialogWrapper {
    private Context context;
    private boolean isShowLoading;

    public AlertDialogWrapper(Context context, boolean isShowLoading) {
        this.context = context;
        this.isShowLoading = isShowLoading;
    }

    public void showDialog(RXDConfig rxdConfig) {
        if (this.isShowLoading) {
            if (rxdConfig.isForceUpdate()) {
                this.showForceDialog(rxdConfig, new ClientVersion[0]);
            } else {
                this.showAlertDialog(rxdConfig, new ClientVersion[0]);
            }
        } else {
            this.downloadApk(rxdConfig);
        }
    }

    public void showDialog(RXDConfig rxdConfig, ClientVersion clientVersion) {
        if (this.isShowLoading) {
            if (rxdConfig.isForceUpdate()) {
                this.showForceDialog(rxdConfig, clientVersion);
            } else {
                this.showAlertDialog(rxdConfig, clientVersion);
            }
        } else {
            this.downloadApk(rxdConfig, clientVersion);
        }
    }

    private void downloadApk(RXDConfig rxdConfig) {
        try {
            DownloadApkTask task = new DownloadApkTask(this.context, rxdConfig);
            task.execute(new String[0]);
        }
        catch (UpdateModuleException e) {
            e.printStackTrace();
        }
    }

    private void downloadApk(RXDConfig rxdConfig, ClientVersion ... clientVersions) {
        try {
            DownloadApkTask task = new DownloadApkTask(this.context, rxdConfig, clientVersions[0]);
            task.execute(new String[0]);
        }
        catch (UpdateModuleException e) {
            e.printStackTrace();
        }
    }

    void showAlertDialog(final RXDConfig rxdConfig, final ClientVersion ... clientVersions) {
        String title = this.context.getResources().getString(R.string.soft_update);
        String resMessage = this.context.getResources().getString(R.string.dialog_proposed_update_message);
        String message = String.format(resMessage, rxdConfig.getUpdate().getVersion(), rxdConfig.getUpdate().getComment());
        String positiveBtn = this.context.getResources().getString(R.string.update_text);
        String negativeBtn = this.context.getResources().getString(R.string.temp_not_update_text);
        AlertDialog dialog = new AlertDialog.Builder(this.context).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)positiveBtn, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TaskManager.setCheckRunning(false);
                UpdateLog.d("alreadyRunning", "alreadyRunning:\u91cd\u7f6e\u4e3afalse");
                AlertDialogWrapper.this.downloadApk(rxdConfig, clientVersions);
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)negativeBtn, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                TaskManager.setCheckRunning(false);
                UpdateLog.d("alreadyRunning", "alreadyRunning:\u91cd\u7f6e\u4e3afalse");
                dialog.dismiss();
            }
        }).create();
        dialog.setCancelable(false);
        dialog.show();
    }

    public void showForceDialog(final RXDConfig rxdConfig, final ClientVersion ... clientVersions) {
        String title = this.context.getResources().getString(R.string.soft_update);
        String resMessage = this.context.getResources().getString(R.string.dialog_force_update_message);
        String message = String.format(resMessage, rxdConfig.getUpdate().getVersion(), rxdConfig.getUpdate().getComment());
        String updateBtn = this.context.getResources().getString(R.string.update_text);
        String exitBtn = this.context.getResources().getString(R.string.exit_text);
        AlertDialog dialog = new AlertDialog.Builder(this.context).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)updateBtn, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TaskManager.setCheckRunning(false);
                UpdateLog.d("alreadyRunning", "alreadyRunning:\u91cd\u7f6e\u4e3afalse");
                AlertDialogWrapper.this.downloadApk(rxdConfig, clientVersions);
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)exitBtn, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                UpdateLog.d("alreadyRunning", "alreadyRunning:\u91cd\u7f6e\u4e3afalse");
                dialog.dismiss();
                UpdateReceiver.onForceUpdateDismiss(AlertDialogWrapper.this.context);
            }
        }).create();
        dialog.setCancelable(false);
        dialog.show();
    }

    public static void downloadFailureDialog(Context context) {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder(context);
        alertBuilder.setTitle((CharSequence)context.getResources().getString(R.string.confirm_tips));
        alertBuilder.setMessage((CharSequence)context.getResources().getString(R.string.download_failure_message));
        alertBuilder.setPositiveButton((CharSequence)context.getResources().getString(R.string.confirm_ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dlg, int which) {
            }
        });
        alertBuilder.setCancelable(false);
        alertBuilder.create().show();
    }
}

