/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.util;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.xdja.upgrade.util.SPUtil;

public class CountdownUtil {
    public static final String UPDATE_TIME = "update_time";
    public static long THREE_DAY = 10800000L;

    public static boolean needUpdate(Context context) {
        long current = System.currentTimeMillis();
        long last = CountdownUtil.getLastUpdateCheckDate(context);
        CountdownUtil.resetAlarm(context);
        return (current - last) / 3600L / 1000L > 72L;
    }

    private static long getLastUpdateCheckDate(Context context) {
        return (Long)SPUtil.get(context, UPDATE_TIME, 0);
    }

    private static void logThisTime(Context context) {
        SPUtil.put(context, UPDATE_TIME, System.currentTimeMillis());
    }

    private static void setNextUpdateTime(Context context) {
        PendingIntent intent = CountdownUtil.getAlarmIntent(context);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        alarm.set(0, System.currentTimeMillis() + THREE_DAY, intent);
    }

    private static void resetAlarm(Context context) {
        CountdownUtil.logThisTime(context);
        CountdownUtil.cancelAlarm(context);
        CountdownUtil.setNextUpdateTime(context);
    }

    private static void cancelAlarm(Context context) {
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        alarm.cancel(CountdownUtil.getAlarmIntent(context));
    }

    private static PendingIntent getAlarmIntent(Context context) {
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(), (int)0x40000000);
    }
}

