/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.validator.support;

import com.xdja.validated.enums.ClassTypeEnum;
import com.xdja.validated.util.StringUtil;
import com.xdja.validated.validator.support.AnnotationCustom;
import com.xdja.validated.validator.support.ParameterType;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationParameterCustom
implements AnnotationCustom {
    private Logger log = LoggerFactory.getLogger(AnnotationParameterCustom.class);

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(ParameterType parameterType, Class<T> annotationClass) {
        return parameterType.getParameter().getDeclaredAnnotation(annotationClass);
    }

    @Override
    public void setDefault(ParameterType parameterType, Object defaultValue, Object[] objects, int index) {
        if (defaultValue != null && StringUtil.isNotBlank(defaultValue.toString())) {
            ClassTypeEnum classTypeEnum = ClassTypeEnum.getValue(parameterType.getParameter().getType().getTypeName());
            try {
                if (classTypeEnum != null) {
                    switch (classTypeEnum) {
                        case PACK_BOOLEAN: {
                            objects[index] = StringUtil.formatBoolean(defaultValue);
                            break;
                        }
                        case PACK_INT: {
                            objects[index] = StringUtil.getIntValue(defaultValue);
                            break;
                        }
                        case PACK_LONG: {
                            objects[index] = StringUtil.getLongValue(defaultValue);
                            break;
                        }
                        case PACK_DOUBLE: {
                            objects[index] = StringUtil.getDoubleValue(defaultValue);
                            break;
                        }
                        case PACK_FLOAT: {
                            objects[index] = Float.valueOf(StringUtil.getFloatValue(defaultValue));
                            break;
                        }
                        case PACK_SHORT: {
                            objects[index] = StringUtil.getShortValue(defaultValue);
                            break;
                        }
                        case BIGDECIMAL: {
                            objects[index] = StringUtil.getBigDecimalValue(defaultValue);
                            break;
                        }
                        case STRING: {
                            objects[index] = defaultValue;
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error(" setDefault error fileName:{}", (Object)parameterType.getParameter().getName());
            }
        }
    }
}

