/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@WebFilter(filterName="XssFilter", urlPatterns={"/*"})
@Component
public class XssFilter
implements Filter {
    private Logger LOG = LoggerFactory.getLogger(XssFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        XssHttpServletRequestWraper xssRequest = new XssHttpServletRequestWraper((HttpServletRequest)request);
        chain.doFilter((ServletRequest)xssRequest, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Component
    class XssHttpServletRequestWraper
    extends HttpServletRequestWrapper {
        public XssHttpServletRequestWraper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            if (XssFilter.this.LOG.isDebugEnabled()) {
                XssFilter.this.LOG.debug("name.......{}", (Object)name);
            }
            String value = this.clearXss(super.getParameter(name));
            value = this.clearSQL(value);
            return value;
        }

        public String[] getParameterValues(String name) {
            String[] values;
            if (XssFilter.this.LOG.isDebugEnabled()) {
                XssFilter.this.LOG.debug("name.......{}", (Object)name);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}) && (values = super.getParameterValues(name)) != null && values.length > 0) {
                String[] newValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (StringUtils.isBlank((CharSequence)values[i])) continue;
                    newValues[i] = this.clearXss(values[i]);
                    newValues[i] = this.clearSQL(newValues[i]);
                }
                return newValues;
            }
            return null;
        }

        private String clearXss(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return value;
            }
            value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            value = value.replaceAll("\\(", "&#40;").replace("\\)", "&#41;");
            value = value.replaceAll("'", "&#39;");
            value = value.replaceAll("eval\\((.*)\\)", "");
            value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
            value = value.replace("script", "");
            value = value.replaceAll("%", "\\\\%");
            return value;
        }

        protected String clearSQL(String str) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{str})) {
                str = str.toLowerCase();
                String badStr = "' or | and |exec|execute|insert|select|delete|update|count|drop|where|chr|mid|master|truncate|table|from|grant|use|group_concat|column_name|";
                String[] badStrs = badStr.split("\\|");
                for (int i = 0; i < badStrs.length; ++i) {
                    str = str.replaceAll(badStrs[i], "");
                }
            }
            return str;
        }

        public String xssEncode(String s) {
            if (s == null || s.isEmpty()) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            block12: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '>': {
                        sb.append('\uff1e');
                        continue block12;
                    }
                    case '<': {
                        sb.append('\uff1c');
                        continue block12;
                    }
                    case '\'': {
                        sb.append('\u2018');
                        continue block12;
                    }
                    case '\"': {
                        sb.append('\u201c');
                        continue block12;
                    }
                    case '&': {
                        sb.append('\uff06');
                        continue block12;
                    }
                    case '\\': {
                        sb.append('\uff3c');
                        continue block12;
                    }
                    case '/': {
                        sb.append('\uff0f');
                        continue block12;
                    }
                    case '#': {
                        sb.append('\uff03');
                        continue block12;
                    }
                    case '(': {
                        sb.append('\uff08');
                        continue block12;
                    }
                    case ')': {
                        sb.append('\uff09');
                        continue block12;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    }
}

