/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.spring.intercept;

import com.xdja.validated.annotation.Validate;
import com.xdja.validated.validator.SpvValidator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class ValidatedAspect {
    private static final Logger log = LoggerFactory.getLogger(ValidatedAspect.class);
    @Autowired
    private SpvValidator validator;
    private static HashMap<String, Class> map = new HashMap<String, Class>(){
        {
            this.put("java.lang.Integer", Integer.TYPE);
            this.put("java.lang.Double", Double.TYPE);
            this.put("java.lang.Float", Float.TYPE);
            this.put("java.lang.Long", Long.TYPE);
            this.put("java.lang.Short", Short.TYPE);
            this.put("java.lang.Boolean", Boolean.TYPE);
            this.put("java.lang.Char", Character.TYPE);
        }
    };

    @Around(value="@annotation(validate)")
    public Object invoke(ProceedingJoinPoint jp, Validate validate) throws Throwable {
        long start = System.currentTimeMillis();
        Object result = null;
        Object[] arguments = jp.getArgs();
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        this.validator.parameterAnnotationValid(method, arguments);
        if (log.isDebugEnabled()) {
            log.debug("param valid time:{}", (Object)(System.currentTimeMillis() - start));
        }
        result = jp.proceed(jp.getArgs());
        return result;
    }

    @Deprecated
    private Map<String, Object> getFieldsName(JoinPoint joinPoint) throws Exception {
        String classType = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        Class[] classes = new Class[args.length];
        for (int k = 0; k < args.length; ++k) {
            if (args[k] instanceof MultipartFile || args[k] instanceof ServletRequest || args[k] instanceof ServletResponse) {
                return null;
            }
            if (args[k].getClass().isPrimitive()) continue;
            String result = args[k].getClass().getName();
            Class<?> s = map.get(result);
            if (s == null) {
                s = args[k].getClass();
            }
            classes[k] = s == null ? args[k].getClass() : s;
        }
        DefaultParameterNameDiscoverer pnd = new DefaultParameterNameDiscoverer();
        Method method = Class.forName(classType).getMethod(methodName, classes);
        String[] parameterNames = pnd.getParameterNames(method);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int i = 0; i < parameterNames.length; ++i) {
            paramMap.put(parameterNames[i], args[i]);
        }
        return paramMap;
    }
}

