/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.spring.intercept;

import com.xdja.validated.annotation.Validate;
import com.xdja.validated.validator.SpvValidator;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class ValidatedMethodIntercept
implements MethodInterceptor {
    private Logger log = LoggerFactory.getLogger(ValidatedMethodIntercept.class);
    public static final String BEAN_NAME = "validatedMethodIntercept";
    @Autowired
    private SpvValidator validator;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        long start = System.currentTimeMillis();
        Object[] params = methodInvocation.getArguments();
        Method method = methodInvocation.getMethod();
        Validate validated = (Validate)AnnotationUtils.findAnnotation((Method)methodInvocation.getMethod(), Validate.class);
        if (validated != null) {
            this.validator.parameterAnnotationValid(method, params);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("valid time:", (Object)(System.currentTimeMillis() - start));
        }
        return methodInvocation.proceed();
    }
}

