/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.util;

import com.xdja.validated.config.GlobalValidatedProperties;
import com.xdja.validated.config.ValidatedMethodPostProcessor;
import com.xdja.validated.spring.intercept.ValidatedMethodIntercept;
import com.xdja.validated.util.ArrayUtils;
import com.xdja.validated.util.PropertiesPlaceholderResolver;
import com.xdja.validated.util.ValidatorUtil;
import com.xdja.validated.validator.SpvValidator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BeanUtil {
    private static final String[] EMPTY_BEAN_NAMES = new String[0];
    private static Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static void registerglobalValidatedProperties(AnnotationAttributes attributes, BeanDefinitionRegistry registry, PropertyResolver propertyResolver, String beanName) {
        if (attributes == null) {
            return;
        }
        BeanUtil.registerGlobalProperties(attributes, registry, propertyResolver, beanName);
    }

    public static void registerGlobalProperties(Map<?, ?> globalProperties, BeanDefinitionRegistry registry, PropertyResolver propertyResolver, String beanName) {
        Properties properties = BeanUtil.resolveProperties(globalProperties, propertyResolver);
        if (properties != null) {
            BeanUtil.registerSingleton(registry, beanName, new GlobalValidatedProperties(properties.getProperty("fileName")));
        }
    }

    public static void registerValidatedMethodPostProcessor(BeanDefinitionRegistry registry) {
        BeanUtil.registerInfrastructureBeanIfAbsent(registry, "validatedMethodPostProcessor", ValidatedMethodPostProcessor.class, new Object[0]);
    }

    public static void registerValidatedMethodInterceptor(BeanDefinitionRegistry registry) {
        BeanUtil.registerInfrastructureBeanIfAbsent(registry, "validatedMethodIntercept", ValidatedMethodIntercept.class, new Object[0]);
    }

    public static void registerValieator(BeanDefinitionRegistry registry) {
        BeanUtil.registerInfrastructureBeanIfAbsent(registry, "spvValidator", SpvValidator.class, new Object[0]);
        BeanUtil.registerInfrastructureBeanIfAbsent(registry, "spvValidatorUtil", ValidatorUtil.class, new Object[0]);
    }

    public static Properties resolveProperties(Map<?, ?> properties, PropertyResolver propertyResolver) {
        PropertiesPlaceholderResolver propertiesPlaceholderResolver = new PropertiesPlaceholderResolver(propertyResolver);
        return propertiesPlaceholderResolver.resolve(properties);
    }

    public static void registerSingleton(BeanDefinitionRegistry registry, String beanName, Object singletonObject) {
        SingletonBeanRegistry beanRegistry = null;
        if (registry instanceof SingletonBeanRegistry) {
            beanRegistry = (SingletonBeanRegistry)registry;
        } else if (registry instanceof AbstractApplicationContext) {
            beanRegistry = ((AbstractApplicationContext)registry).getBeanFactory();
        }
        if (beanRegistry != null) {
            beanRegistry.registerSingleton(beanName, singletonObject);
        }
    }

    public static void registerInfrastructureBeanIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        if (!BeanUtil.isBeanDefinitionPresent(registry, beanName, beanClass) && !registry.containsBeanDefinition(beanName)) {
            BeanUtil.registerInfrastructureBean(registry, beanName, beanClass, constructorArgs);
        }
    }

    public static void registerInfrastructureBean(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Object ... constructorArgs) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        for (Object constructorArg : constructorArgs) {
            beanDefinitionBuilder.addConstructorArgValue(constructorArg);
        }
        beanDefinitionBuilder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public static boolean isBeanDefinitionPresent(BeanDefinitionRegistry registry, String beanName, Class<?> targetBeanClass) {
        Object[] beanNames = BeanUtil.getBeanNames((ListableBeanFactory)registry, targetBeanClass);
        return ArrayUtils.contains(beanNames, beanName);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtil.getBeanNames(beanFactory, beanClass, false);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        ListableBeanFactory actualBeanFactory;
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)ConfigurableApplicationContext.class.cast(beanFactory);
            actualBeanFactory = applicationContext.getBeanFactory();
        } else {
            actualBeanFactory = beanFactory;
        }
        if (actualBeanFactory instanceof ConfigurableListableBeanFactory) {
            return BeanUtil.getBeanNames((ConfigurableListableBeanFactory)actualBeanFactory, beanClass, includingAncestors);
        }
        return EMPTY_BEAN_NAMES;
    }

    public static String[] getBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        BeanFactory parentBeanFactory;
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        beanNames.addAll(BeanUtil.doGetBeanNames(beanFactory, beanClass));
        if (includingAncestors && (parentBeanFactory = beanFactory.getParentBeanFactory()) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)parentBeanFactory;
            String[] parentBeanNames = BeanUtil.getBeanNames(configurableListableBeanFactory, beanClass, includingAncestors);
            beanNames.addAll(Arrays.asList(parentBeanNames));
        }
        return StringUtils.toStringArray(beanNames);
    }

    protected static Set<String> doGetBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanType) {
        String[] allBeanNames = beanFactory.getBeanDefinitionNames();
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        for (String beanName : allBeanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            Class<?> beanClass = BeanUtil.resolveBeanType(beanFactory, beanDefinition);
            if (beanClass == null || !ClassUtils.isAssignable(beanType, beanClass)) continue;
            beanNames.add(beanName);
        }
        return Collections.unmodifiableSet(beanNames);
    }

    private static Class<?> resolveBeanType(ConfigurableListableBeanFactory beanFactory, BeanDefinition beanDefinition) {
        String beanClassName;
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        ClassLoader classLoader = beanFactory.getBeanClassLoader();
        Class<?> beanType = null;
        if (StringUtils.hasText((String)factoryBeanName)) {
            beanType = BeanUtil.getFactoryBeanType(beanFactory, beanDefinition);
        }
        if (beanType == null && StringUtils.hasText((String)(beanClassName = beanDefinition.getBeanClassName()))) {
            beanType = BeanUtil.resolveBeanType(beanClassName, classLoader);
        }
        if (beanType == null && log.isErrorEnabled()) {
            String message = beanDefinition + " can't be resolved bean type!";
            log.error(message);
        }
        return beanType;
    }

    private static Class<?> getFactoryBeanType(ConfigurableListableBeanFactory beanFactory, BeanDefinition factoryBeanDefinition) {
        BeanDefinition actualFactoryBeanDefinition = factoryBeanDefinition;
        final ArrayList beanClasses = new ArrayList(1);
        ClassLoader classLoader = beanFactory.getBeanClassLoader();
        String factoryBeanClassName = actualFactoryBeanDefinition.getBeanClassName();
        if (StringUtils.isEmpty((Object)factoryBeanClassName)) {
            String factoryBeanName = factoryBeanDefinition.getFactoryBeanName();
            actualFactoryBeanDefinition = beanFactory.getBeanDefinition(factoryBeanName);
            factoryBeanClassName = actualFactoryBeanDefinition.getBeanClassName();
        }
        if (StringUtils.hasText((String)factoryBeanClassName)) {
            Class<?> factoryBeanClass = BeanUtil.resolveBeanType(factoryBeanClassName, classLoader);
            final String factoryMethodName = factoryBeanDefinition.getFactoryMethodName();
            ReflectionUtils.doWithMethods(factoryBeanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    beanClasses.add(method.getReturnType());
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return factoryMethodName.equals(method.getName());
                }
            });
        }
        return beanClasses.isEmpty() ? null : (Class)beanClasses.get(0);
    }

    public static Class<?> resolveBeanType(String beanClassName, ClassLoader classLoader) {
        Class beanType;
        block3: {
            if (!StringUtils.hasText((String)beanClassName)) {
                return null;
            }
            beanType = null;
            try {
                beanType = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)classLoader);
                beanType = ClassUtils.getUserClass((Class)beanType);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return beanType;
    }
}

