/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.util;

import com.xdja.validated.exception.ValidatedException;
import com.xdja.validated.util.StringUtil;
import com.xdja.validated.util.ValidatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    private static Logger log = LoggerFactory.getLogger(ExceptionUtil.class);

    public static void throwException(Object message, String fieldName) {
        String msg;
        if (message != null && StringUtil.isNotBlank(msg = ValidatorUtil.filterMsg(message.toString()))) {
            throw new ValidatedException(msg, fieldName);
        }
    }

    public static void throwException(String message, String fieldName) {
        String msg;
        if (StringUtil.isNotBlank(message) && StringUtil.isNotBlank(msg = ValidatorUtil.filterMsg(message))) {
            if (log.isDebugEnabled()) {
                log.debug("ExceptionUtil msg:" + message + " fieldName:" + fieldName);
            }
            throw new ValidatedException(msg, fieldName);
        }
    }

    public static void throwExceptionNotCheckMsg(String message, String fieldName) {
        if (StringUtil.isNotBlank(message)) {
            if (log.isDebugEnabled()) {
                log.debug("ExceptionUtil msg:" + message + " fieldName:" + fieldName);
            }
            throw new ValidatedException(message, fieldName);
        }
    }
}

