/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.util;

import java.math.BigDecimal;

public final class StringUtil {
    private static final String EMPTY = "";

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String formatString(Object object) {
        if (object == null) {
            return EMPTY;
        }
        return object.toString();
    }

    public static boolean isDigits(String str) {
        return StringUtil.isNumeric(str);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtil.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String str) {
        return StringUtil.changeFirstCharacterCase(str, true);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str.length());
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static int getIntValue(Object object) {
        if (object == null) {
            return 0;
        }
        String str = object.toString();
        if (!StringUtil.isNumeric(str)) {
            return 0;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long getLongValue(Object object) {
        if (object == null) {
            return 0L;
        }
        String str = object.toString();
        if (!StringUtil.isNumeric(str)) {
            return 0L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static double getDoubleValue(Object object) {
        if (object == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(object.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static float getFloatValue(Object object) {
        if (object == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(object.toString()).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static short getShortValue(Object object) {
        if (object == null) {
            return 0;
        }
        try {
            return Short.valueOf(object.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static BigDecimal getBigDecimalValue(Object object) {
        if (object == null) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(object.toString());
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static boolean formatBoolean(Object object) {
        if (object == null) {
            return false;
        }
        String str = object.toString();
        try {
            return Boolean.valueOf(str);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.getLongValue("10"));
        System.out.println(StringUtil.getDoubleValue("0.11"));
        System.out.println(StringUtil.getFloatValue("0.12"));
        System.out.println(StringUtil.getShortValue("13"));
        System.out.println(StringUtil.getBigDecimalValue("14.35"));
    }
}

