/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.util;

import com.xdja.validated.annotation.AssertFalse;
import com.xdja.validated.annotation.AssertTrue;
import com.xdja.validated.annotation.BankCard;
import com.xdja.validated.annotation.CreditCard;
import com.xdja.validated.annotation.Default;
import com.xdja.validated.annotation.Digits;
import com.xdja.validated.annotation.Email;
import com.xdja.validated.annotation.FileSuffix;
import com.xdja.validated.annotation.IdCard;
import com.xdja.validated.annotation.Length;
import com.xdja.validated.annotation.NotBlank;
import com.xdja.validated.annotation.NotEmpty;
import com.xdja.validated.annotation.NotEqualSize;
import com.xdja.validated.annotation.NotNull;
import com.xdja.validated.annotation.Pattern;
import com.xdja.validated.annotation.Phone;
import com.xdja.validated.annotation.Size;
import com.xdja.validated.util.ExceptionUtil;
import com.xdja.validated.util.StringUtil;
import com.xdja.validated.validator.support.ParameterType;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ValidatorUtil
implements BeanFactoryAware {
    private static Logger log = LoggerFactory.getLogger(ValidatorUtil.class);
    public static final String BEAN_NAME = "spvValidatorUtil";
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private static ResourceBundle resourceBundle;
    private static String fileName;
    private static final java.util.regex.Pattern pattern;
    private static final java.util.regex.Pattern BANKCARD_PATTERN;
    private static final java.util.regex.Pattern CREDIT_CARD_PATTERN;
    private static final java.util.regex.Pattern EMAIL_PATTERN;
    private static final java.util.regex.Pattern PHONE_PATTERN;
    private static final java.util.regex.Pattern ID_CARD_PATTERN;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        SingletonBeanRegistry beanRegistry = null;
        if (beanFactory instanceof SingletonBeanRegistry) {
            beanRegistry = (SingletonBeanRegistry)beanFactory;
        } else if (beanFactory instanceof AbstractApplicationContext) {
            beanRegistry = ((AbstractApplicationContext)beanFactory).getBeanFactory();
        }
    }

    public static String[] getMethodParameter(Method method) {
        return discoverer.getParameterNames(method);
    }

    public static void checkNotBlank(ParameterType parameterType) {
        Object value = parameterType.getValue();
        NotBlank notBlank = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, NotBlank.class);
        if (value == null || StringUtil.isBlank(value.toString())) {
            ExceptionUtil.throwException(notBlank.msg(), parameterType.getFieldName());
        }
    }

    public static void checkLength(ParameterType parameterType) {
        Object value = parameterType.getValue();
        Length length = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Length.class);
        if (length != null && value != null && value != "") {
            int valueLength = 0;
            int min = length.min();
            int max = length.max();
            if (value != null) {
                valueLength = value.toString().length();
            }
            if (min > valueLength || valueLength > max) {
                String msg = ValidatorUtil.filterMsg(length.msg());
                msg = String.format(msg, min, max);
                ExceptionUtil.throwExceptionNotCheckMsg(msg, parameterType.getFieldName());
            }
        }
    }

    public static void checkDefault(ParameterType parameterType, Object[] params, int index) {
        Default aDefault = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Default.class);
        if (aDefault != null) {
            if (parameterType.getField() != null) {
                if (StringUtils.isEmpty((Object)parameterType.getValue())) {
                    parameterType.getAnnotationCustom().setDefault(parameterType, aDefault.value(), params, index);
                }
            } else if (parameterType.getParameter() != null && StringUtils.isEmpty((Object)params[index])) {
                parameterType.getAnnotationCustom().setDefault(parameterType, aDefault.value(), params, index);
            }
        }
    }

    public static void checkAssertTrue(ParameterType parameterType) {
        Object value;
        String strValue;
        AssertTrue assertTrue = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, AssertTrue.class);
        if (assertTrue != null && !"true".equalsIgnoreCase(strValue = StringUtil.formatString(value = parameterType.getValue()))) {
            ExceptionUtil.throwException(assertTrue.msg(), parameterType.getFieldName());
        }
    }

    public static void checkAssertFalse(ParameterType parameterType) {
        Object value;
        String strValue;
        AssertFalse assertFalse = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, AssertFalse.class);
        if (assertFalse != null && !"false".equalsIgnoreCase(strValue = StringUtil.formatString(value = parameterType.getValue()))) {
            ExceptionUtil.throwException(assertFalse.msg(), parameterType.getFieldName());
        }
    }

    public static void checkBankCard(ParameterType parameterType) {
        BankCard bankCard = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, BankCard.class);
        if (bankCard != null) {
            Object value = parameterType.getValue();
            String str = StringUtil.formatString(value);
            if (StringUtil.isBlank(str)) {
                ExceptionUtil.throwException(bankCard.msg(), parameterType.getFieldName());
            } else {
                String regexp = bankCard.regexp();
                if (BANKCARD_PATTERN.pattern().equals(regexp)) {
                    boolean isMatcher = BANKCARD_PATTERN.matcher(str).matches();
                    if (!isMatcher) {
                        ExceptionUtil.throwException(bankCard.msg(), parameterType.getFieldName());
                    }
                } else {
                    java.util.regex.Pattern pattern = StringUtil.isBlank(regexp) ? BANKCARD_PATTERN : java.util.regex.Pattern.compile(regexp);
                    if (!pattern.matcher(str).matches()) {
                        ExceptionUtil.throwException(bankCard.msg(), parameterType.getFieldName());
                    }
                }
            }
        }
    }

    public static void checkCreditCard(ParameterType parameterType) {
        CreditCard creditCard = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, CreditCard.class);
        if (creditCard != null) {
            Object value = parameterType.getValue();
            String str = StringUtil.formatString(value);
            if (StringUtil.isBlank(str)) {
                ExceptionUtil.throwException(creditCard.msg(), parameterType.getFieldName());
            } else {
                String regexp = creditCard.regexp();
                if (CREDIT_CARD_PATTERN.pattern().equals(regexp)) {
                    boolean isMatcher = CREDIT_CARD_PATTERN.matcher(str).matches();
                    if (!isMatcher) {
                        ExceptionUtil.throwException(creditCard.msg(), parameterType.getFieldName());
                    }
                } else {
                    java.util.regex.Pattern pattern = StringUtil.isBlank(regexp) ? CREDIT_CARD_PATTERN : java.util.regex.Pattern.compile(regexp);
                    if (!pattern.matcher(str).matches()) {
                        ExceptionUtil.throwException(creditCard.msg(), parameterType.getFieldName());
                    }
                }
            }
        }
    }

    public static void checkSize(ParameterType parameterType) {
        Object objectValue = parameterType.getValue();
        Size size = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Size.class);
        if (size != null && objectValue != null && objectValue != "") {
            String msg = ValidatorUtil.filterMsg(size.msg());
            long value = 0L;
            long min = size.min();
            long max = size.max();
            if (objectValue != null) {
                value = StringUtil.getLongValue(objectValue);
            }
            if ((min > value || value > max) && StringUtil.isNotBlank(msg)) {
                msg = String.format(msg, min, max);
                ExceptionUtil.throwExceptionNotCheckMsg(msg, parameterType.getFieldName());
            }
        }
    }

    public static void checkNotNull(ParameterType parameterType) {
        Object value = parameterType.getValue();
        NotNull notBlank = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, NotNull.class);
        if (value == null) {
            ExceptionUtil.throwException(notBlank.msg(), parameterType.getFieldName());
        }
    }

    public static void checkPattern(ParameterType parameterType) {
        Pattern pattern = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Pattern.class);
        if (pattern != null) {
            Object objectValue = parameterType.getValue();
            if (objectValue == null) {
                ExceptionUtil.throwException(pattern.msg(), parameterType.getFieldName());
            } else {
                java.util.regex.Pattern patternV;
                String regexp = pattern.regexp();
                String str = StringUtil.formatString(objectValue);
                if (StringUtil.isNotBlank(regexp) && !(patternV = java.util.regex.Pattern.compile(pattern.regexp())).matcher(str).matches()) {
                    ExceptionUtil.throwException(pattern.msg(), parameterType.getFieldName());
                }
            }
        }
    }

    public static void checkEmail(ParameterType parameterType) {
        Email email = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Email.class);
        if (email != null) {
            Object objectValue = parameterType.getValue();
            String regexp = email.regexp();
            String value = StringUtil.formatString(objectValue);
            if (StringUtil.isBlank(value)) {
                ExceptionUtil.throwException(email.msg(), parameterType.getFieldName());
            }
            if (EMAIL_PATTERN.pattern().equals(regexp)) {
                boolean isMatcher = EMAIL_PATTERN.matcher(value).matches();
                if (!isMatcher) {
                    ExceptionUtil.throwException(email.msg(), parameterType.getFieldName());
                }
            } else {
                java.util.regex.Pattern pattern = StringUtil.isBlank(regexp) ? EMAIL_PATTERN : java.util.regex.Pattern.compile(regexp);
                if (!pattern.matcher(value).matches()) {
                    ExceptionUtil.throwException(email.msg(), parameterType.getFieldName());
                }
            }
        }
    }

    public static void checkPhone(ParameterType parameterType) {
        Phone phone = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Phone.class);
        if (phone != null) {
            Object objectValue = parameterType.getValue();
            String regexp = phone.regexp();
            String value = StringUtil.formatString(objectValue);
            if (StringUtil.isBlank(value)) {
                ExceptionUtil.throwException(phone.msg(), parameterType.getFieldName());
            } else if (PHONE_PATTERN.pattern().equals(regexp)) {
                boolean isMatcher = PHONE_PATTERN.matcher(value).matches();
                if (!isMatcher) {
                    ExceptionUtil.throwException(phone.msg(), parameterType.getFieldName());
                }
            } else {
                java.util.regex.Pattern pattern = StringUtil.isBlank(regexp) ? PHONE_PATTERN : java.util.regex.Pattern.compile(regexp);
                if (!pattern.matcher(value).matches()) {
                    ExceptionUtil.throwException(phone.msg(), parameterType.getFieldName());
                }
            }
        }
    }

    public static void checkDigits(ParameterType parameterType) {
        String strValue;
        Digits digits = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, Digits.class);
        if (digits != null && !StringUtil.isDigits(strValue = StringUtil.formatString(parameterType.getValue()))) {
            ExceptionUtil.throwException(digits.msg(), parameterType.getFieldName());
        }
    }

    public static void checkIdCard(ParameterType parameterType) {
        IdCard idCard = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, IdCard.class);
        if (idCard != null) {
            Object objectValue = parameterType.getValue();
            String regexp = idCard.regexp();
            String value = StringUtil.formatString(objectValue);
            if (StringUtil.isBlank(value)) {
                ExceptionUtil.throwException(idCard.msg(), parameterType.getFieldName());
            } else if (ID_CARD_PATTERN.pattern().equals(regexp)) {
                boolean isMatcher = ID_CARD_PATTERN.matcher(value).matches();
                if (!isMatcher) {
                    ExceptionUtil.throwException(idCard.msg(), parameterType.getFieldName());
                }
                if (idCard.below18()) {
                    ValidatorUtil.checkIdCard(value, idCard.below18Msg(), parameterType);
                }
            } else {
                java.util.regex.Pattern pattern = StringUtil.isBlank(regexp) ? ID_CARD_PATTERN : java.util.regex.Pattern.compile(regexp);
                if (!pattern.matcher(value).matches()) {
                    ExceptionUtil.throwException(idCard.msg(), parameterType.getFieldName());
                }
                if (idCard.below18()) {
                    ValidatorUtil.checkIdCard(value, idCard.below18Msg(), parameterType);
                }
            }
        }
    }

    public static void checkNotEmpty(ParameterType parameterType) {
        Object value = parameterType.getValue();
        NotEmpty notEmpty = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, NotEmpty.class);
        if (value == null || "".equals(value.toString())) {
            ExceptionUtil.throwException(notEmpty.msg(), parameterType.getFieldName());
        }
    }

    public static void checkNotEqualSize(ParameterType parameterType) {
        Object value = parameterType.getValue();
        NotEqualSize notEqualSize = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, NotEqualSize.class);
        if (notEqualSize != null) {
            int valueLength = 0;
            int size = notEqualSize.size();
            if (value != null) {
                valueLength = value.toString().length();
            }
            if (value == null || valueLength != size) {
                ExceptionUtil.throwException(notEqualSize.msg(), parameterType.getFieldName());
            }
        }
    }

    private static void checkIdCard(String idCard, String msg, ParameterType parameterType) {
        if (idCard.length() == 18) {
            String chkidcard = idCard.substring(6, 10);
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            if (year - StringUtil.getIntValue(chkidcard) < 18) {
                ExceptionUtil.throwException(msg, parameterType.getFieldName());
            }
        }
    }

    public static String filterMsg(String msg) {
        boolean isDefaultMsg = pattern.matcher(msg).lookingAt();
        if (isDefaultMsg) {
            msg = ValidatorUtil.getMsg(msg);
        }
        return msg;
    }

    public static void checkFileType(ParameterType parameterType) {
        Object fileObj = parameterType.getValue();
        if (fileObj != null && fileObj instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)fileObj;
            FileSuffix fileSuffix = parameterType.getAnnotationCustom().getDeclaredAnnotation(parameterType, FileSuffix.class);
            long size = fileSuffix.size();
            long fileSize = multipartFile.getSize();
            if (fileSize > size || fileSize == 0L) {
                String msg = ValidatorUtil.filterMsg(fileSuffix.msg());
                ExceptionUtil.throwException(msg, parameterType.getFieldName());
            }
            String fileName = multipartFile.getOriginalFilename();
            for (String suffix : fileSuffix.suffix()) {
                if (!fileName.toLowerCase().endsWith(suffix.toLowerCase())) continue;
                return;
            }
            String msg = ValidatorUtil.filterMsg(fileSuffix.msg());
            ExceptionUtil.throwException(msg, parameterType.getFieldName());
        }
    }

    private static String getMsg(String msg) {
        if (resourceBundle.containsKey(msg)) {
            msg = resourceBundle.getString(msg);
        } else {
            MissingResourceException exception = new MissingResourceException(" is not key", fileName, msg);
            log.error("fileName:" + fileName + " is not key:" + msg, (Throwable)exception);
        }
        return msg;
    }

    static {
        pattern = java.util.regex.Pattern.compile("com.spv.valid");
        BANKCARD_PATTERN = java.util.regex.Pattern.compile("^([1-9]{1})(\\d{14}|\\d{18})$");
        CREDIT_CARD_PATTERN = java.util.regex.Pattern.compile("(?:3[47][0-9]{13})|(?:3(?:0[0-5]|[68][0-9])[0-9]{11})|(?:6(?:011|5[0-9]{2})(?:[0-9]{12}))|(?:(?:2131|1800|35\\\\d{3})\\\\d{11})|(?:(?:5[0678]\\\\d\\\\d|6304|6390|67\\\\d\\\\d)\\\\d{8,15})|(?:(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12})|(?:4[0-9]{12})(?:[0-9]{3})?");
        EMAIL_PATTERN = java.util.regex.Pattern.compile("^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$");
        PHONE_PATTERN = java.util.regex.Pattern.compile("^(((13[0-9])|(14[579])|(15[^4,\\D])|(18[0-9])|(17[0-9]))|(19[8,9])|166)\\d{8}$");
        ID_CARD_PATTERN = java.util.regex.Pattern.compile("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx])|([1\u22129]\\d5\\d2((0[1\u22129])|(10|11|12))(([0\u22122][1\u22129])|10|20|30|31)\\d2[0\u22129Xx])");
    }
}

