/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.validator;

import com.xdja.validated.annotation.Mars;
import com.xdja.validated.annotation.Validate;
import com.xdja.validated.constraint.Constraint;
import com.xdja.validated.constraint.ConstraintValidator;
import com.xdja.validated.enums.AnnotationTypeEnum;
import com.xdja.validated.enums.ClassTypeEnum;
import com.xdja.validated.util.ClassTypeUtil;
import com.xdja.validated.util.ExceptionUtil;
import com.xdja.validated.util.IgnoreClassUtil;
import com.xdja.validated.util.MethodUtil;
import com.xdja.validated.util.ValidatorUtil;
import com.xdja.validated.validator.Validator;
import com.xdja.validated.validator.support.AnnotationCustom;
import com.xdja.validated.validator.support.AnnotationFieldCustom;
import com.xdja.validated.validator.support.AnnotationParameterCustom;
import com.xdja.validated.validator.support.ParameterType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class SpvValidator
implements Validator {
    public static final String BEAN_NAME = "spvValidator";
    private static Logger log = LoggerFactory.getLogger(SpvValidator.class);
    private static final String METHOD_NAME_IS_VALID = "isValid";
    private static final String METHOD_NAME_MODIFY = "modify";
    private static final String ANNOTATION_MSG = "msg";
    private AnnotationCustom annotationFieldCustom = new AnnotationFieldCustom();
    private AnnotationCustom annotationParameterCustom = new AnnotationParameterCustom();

    @Override
    public void validParameter(AnnotationTypeEnum annotationTypeEnum, ParameterType parameterType, Object[] params, int index) {
        this.validParameterAndEntityFields(annotationTypeEnum, parameterType, params, index);
    }

    @Override
    public void validEntityFields(AnnotationTypeEnum annotationTypeEnum, ParameterType parameterType, Object[] params, int index) {
        this.validParameterAndEntityFields(annotationTypeEnum, parameterType, params, index);
    }

    private void validParameterAndEntityFields(AnnotationTypeEnum annotationTypeEnum, ParameterType parameterType, Object[] params, int index) {
        if (annotationTypeEnum != null) {
            switch (annotationTypeEnum) {
                case NOTBLANK: {
                    ValidatorUtil.checkNotBlank(parameterType);
                    break;
                }
                case LENGTH: {
                    ValidatorUtil.checkLength(parameterType);
                    break;
                }
                case DEFAULT: {
                    ValidatorUtil.checkDefault(parameterType, params, index);
                    break;
                }
                case ASSERTTRUE: {
                    ValidatorUtil.checkAssertTrue(parameterType);
                    break;
                }
                case ASSERTFALSE: {
                    ValidatorUtil.checkAssertFalse(parameterType);
                    break;
                }
                case BANKCARD: {
                    ValidatorUtil.checkBankCard(parameterType);
                    break;
                }
                case CREDITCARD: {
                    ValidatorUtil.checkCreditCard(parameterType);
                    break;
                }
                case SIZE: {
                    ValidatorUtil.checkSize(parameterType);
                    break;
                }
                case NOTNULL: {
                    ValidatorUtil.checkNotNull(parameterType);
                    break;
                }
                case PATTERN: {
                    ValidatorUtil.checkPattern(parameterType);
                    break;
                }
                case EMAIL: {
                    ValidatorUtil.checkEmail(parameterType);
                    break;
                }
                case PHONE: {
                    ValidatorUtil.checkPhone(parameterType);
                    break;
                }
                case IDCARD: {
                    ValidatorUtil.checkIdCard(parameterType);
                    break;
                }
                case DIGITS: {
                    ValidatorUtil.checkDigits(parameterType);
                    break;
                }
                case NOT_EMPTY: {
                    ValidatorUtil.checkNotEmpty(parameterType);
                    break;
                }
                case NOT_EQUAL_SIZE: {
                    ValidatorUtil.checkNotEqualSize(parameterType);
                }
                case File_Suffix: {
                    ValidatorUtil.checkFileType(parameterType);
                }
            }
        }
    }

    @Override
    public void entityFieldsAnnotationValid(Validate validated, String valueTypeName, Class<?> clazz, Object[] params, int index) {
        if (!IgnoreClassUtil.checkIgnorePackage(valueTypeName)) {
            Field[] fields;
            this.checkClassSuper(validated, clazz, params, index);
            Class<?>[] validClass = validated.validClass();
            if (!this.isValidClass(validClass, clazz)) {
                return;
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                Annotation[] annotations = field.getDeclaredAnnotations();
                if (annotations == null || annotations.length <= 0) continue;
                field.setAccessible(true);
                for (Annotation annotation : annotations) {
                    Mars mars = annotation.annotationType().getDeclaredAnnotation(Mars.class);
                    String fileName = field.getName();
                    Object valueObject = MethodUtil.getMethod(clazz, field, params[index], fileName);
                    if (mars != null) {
                        String annotationName = annotation.annotationType().getSimpleName();
                        AnnotationTypeEnum annotationTypeEnum = AnnotationTypeEnum.getValue(annotationName);
                        ParameterType parameterType = new ParameterType(valueObject, field, this.annotationFieldCustom);
                        if (annotationTypeEnum == AnnotationTypeEnum.DEFAULT) {
                            this.validEntityFields(annotationTypeEnum, parameterType, params, index);
                            continue;
                        }
                        this.validEntityFields(annotationTypeEnum, parameterType, null, 0);
                        continue;
                    }
                    String fieldTypeName = field.getType().getName();
                    this.checkCustomValid(annotation, valueObject, fieldTypeName, fileName, params, index, field);
                }
            }
        }
    }

    private boolean isValidClass(Class<?>[] validClass, Class<?> clazz) {
        if (validClass.length == 0) {
            return true;
        }
        return Arrays.asList(validClass).contains(clazz);
    }

    private void checkClassSuper(Validate validated, Class clazz, Object[] params, int index) {
        String superValueTypeName;
        ClassTypeEnum classTypeEnum;
        Class superclass = clazz.getSuperclass();
        if (superclass != null && (classTypeEnum = ClassTypeUtil.getClassTypeEnum(superValueTypeName = superclass.getName())) == null) {
            this.entityFieldsAnnotationValid(validated, superValueTypeName, superclass, params, index);
        }
    }

    public static <T> T get(Class<T> clz, Object o) {
        if (clz.isInstance(o)) {
            return clz.cast(o);
        }
        return null;
    }

    @Override
    public void parameterAnnotationValid(Method method, Object[] params) {
        Parameter[] parameters = method.getParameters();
        Validate validated = method.getDeclaredAnnotation(Validate.class);
        if (parameters != null && parameters.length > 0) {
            String[] methodParameters = null;
            for (int j = 0; j < parameters.length; ++j) {
                Parameter parameter;
                Class<?> classType;
                String parameterTypeName;
                if (methodParameters == null) {
                    methodParameters = ValidatorUtil.getMethodParameter(method);
                }
                if ((parameterTypeName = (classType = (parameter = parameters[j]).getType()).getTypeName()).equals("org.springframework.web.multipart.MultipartFile")) {
                    parameter.getDeclaredAnnotations();
                    AnnotationTypeEnum annotationTypeEnum = AnnotationTypeEnum.getValue("FileSuffix");
                    ParameterType parameterType = new ParameterType(methodParameters[j], params[j], parameter, this.annotationParameterCustom);
                    this.validParameter(annotationTypeEnum, parameterType, null, 0);
                    continue;
                }
                ClassTypeEnum classTypeEnum = ClassTypeUtil.getClassTypeEnum(parameterTypeName);
                if (classTypeEnum == null) {
                    this.entityFieldsAnnotationValid(validated, parameterTypeName, parameter.getType(), params, j);
                    continue;
                }
                Annotation[] annotations = parameter.getDeclaredAnnotations();
                if (annotations == null || annotations.length <= 0) continue;
                for (Annotation annotation : annotations) {
                    Mars mars = annotation.annotationType().getDeclaredAnnotation(Mars.class);
                    Object valueObject = params[j];
                    String methodParameter = methodParameters[j];
                    if (mars != null) {
                        String annotationName = annotation.annotationType().getSimpleName();
                        AnnotationTypeEnum annotationTypeEnum = AnnotationTypeEnum.getValue(annotationName);
                        ParameterType parameterType = new ParameterType(methodParameter, valueObject, parameter, this.annotationParameterCustom);
                        if (annotationTypeEnum == AnnotationTypeEnum.DEFAULT) {
                            this.validParameter(annotationTypeEnum, parameterType, params, j);
                            continue;
                        }
                        this.validParameter(annotationTypeEnum, parameterType, null, 0);
                        continue;
                    }
                    this.checkCustomValid(annotation, params[j], params, j, classTypeEnum, methodParameter, null);
                }
            }
        }
    }

    @Override
    public void checkCustomValid(Annotation annotation, Object value, Object[] params, int index, ClassTypeEnum fieldType, String fieldName, Field field) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Constraint constraint = annotationType.getDeclaredAnnotation(Constraint.class);
        if (constraint != null) {
            Class<? extends ConstraintValidator<? extends Annotation, ?>>[] classes = constraint.validatedBy();
            if (classes == null || classes.length <= 0) {
                return;
            }
            for (Class<ConstraintValidator<Annotation, ?>> clazz : classes) {
                Method modifyMethod;
                Method annotationMethod;
                boolean isValid;
                Object instanceObject;
                Class<?>[] interfaces = clazz.getInterfaces();
                if (interfaces == null || interfaces.length <= 0 || !interfaces[0].isAssignableFrom(ConstraintValidator.class) || (instanceObject = MethodUtil.getInstance(clazz)) == null) continue;
                Method method = MethodUtil.getMethod(clazz, METHOD_NAME_IS_VALID, Annotation.class, Object.class);
                if (method != null && !(isValid = ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)instanceObject, (Object[])new Object[]{annotation, value})).booleanValue()) && (annotationMethod = MethodUtil.getAnnotationTypeMethod(annotationType, ANNOTATION_MSG, new Class[0])) != null) {
                    Object msgValue = ReflectionUtils.invokeMethod((Method)annotationMethod, (Object)annotation);
                    ExceptionUtil.throwException(msgValue, fieldName);
                }
                if ((modifyMethod = this.getMethod(clazz, METHOD_NAME_MODIFY)) == null) continue;
                try {
                    Object newValue = ReflectionUtils.invokeMethod((Method)modifyMethod, (Object)instanceObject, (Object[])new Object[]{annotation, value});
                    if (log.isDebugEnabled()) {
                        log.debug("newValue:" + newValue + " oldValue:" + value);
                    }
                    if (field != null) {
                        field.set(params[index], newValue);
                    } else {
                        params[index] = newValue;
                    }
                    value = newValue;
                }
                catch (Exception e) {
                    log.error("invoke method error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void checkCustomValid(Annotation annotation, Object value, String fieldType, String fieldName, Object[] params, int index, Field field) {
        ClassTypeEnum classTypeEnum = ClassTypeUtil.getClassTypeEnum(fieldType);
        if (classTypeEnum != null) {
            this.checkCustomValid(annotation, value, params, index, classTypeEnum, fieldName, field);
        }
    }

    public Method getMethod(Class clazz, String methodName) {
        Method[] methods = clazz.getDeclaredMethods();
        if (methods != null && methods.length > 0) {
            for (Method method : methods) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        }
        return null;
    }
}

