/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.validated.validator.support;

import com.xdja.validated.enums.ClassTypeEnum;
import com.xdja.validated.util.StringUtil;
import com.xdja.validated.validator.support.AnnotationCustom;
import com.xdja.validated.validator.support.ParameterType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationFieldCustom
implements AnnotationCustom {
    private Logger log = LoggerFactory.getLogger(AnnotationFieldCustom.class);

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(ParameterType parameterType, Class<T> annotationClass) {
        return parameterType.getField().getDeclaredAnnotation(annotationClass);
    }

    @Override
    public void setDefault(ParameterType parameterType, Object defaultValue, Object[] objects, int index) {
        if (defaultValue != null && StringUtil.isNotBlank(defaultValue.toString())) {
            Field field = parameterType.getField();
            Object object = objects[index];
            ClassTypeEnum classTypeEnum = ClassTypeEnum.getValue(parameterType.getField().getType().getName());
            try {
                if (classTypeEnum != null) {
                    switch (classTypeEnum) {
                        case PACK_BOOLEAN: {
                            field.set(object, StringUtil.formatBoolean(defaultValue));
                            break;
                        }
                        case PACK_INT: {
                            field.set(object, StringUtil.getIntValue(defaultValue));
                            break;
                        }
                        case PACK_LONG: {
                            field.set(object, StringUtil.getLongValue(defaultValue));
                            break;
                        }
                        case PACK_DOUBLE: {
                            field.set(object, StringUtil.getDoubleValue(defaultValue));
                            break;
                        }
                        case PACK_FLOAT: {
                            field.set(object, Float.valueOf(StringUtil.getFloatValue(defaultValue)));
                            break;
                        }
                        case PACK_SHORT: {
                            field.set(object, StringUtil.getShortValue(defaultValue));
                            break;
                        }
                        case BIGDECIMAL: {
                            field.set(object, StringUtil.getBigDecimalValue(defaultValue));
                            break;
                        }
                        case STRING: {
                            field.set(object, defaultValue);
                            break;
                        }
                    }
                    return;
                }
            }
            catch (Exception e) {
                this.log.error("1 setDefault field error fieldTypeName:" + parameterType.getField().getName() + " defaultValue:" + defaultValue);
            }
            if (object != null) {
                try {
                    field.set(object, defaultValue);
                }
                catch (Exception e) {
                    this.log.error("2 setDefault field error fieldTypeName:" + parameterType.getField().getName() + " defaultValue:" + defaultValue);
                }
            }
        }
    }
}

