/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.dirapi;

import com.xdja.datamigration.dirapi.SocketWrap;
import com.xdja.datamigration.dirapi.bean.EncryptDirParams;
import com.xdja.datamigration.dirapi.exception.DirCryptoException;
import com.xdja.datamigration.dirapi.request.CancelTaskRequest;
import com.xdja.datamigration.dirapi.request.EncryptDirRequest;
import com.xdja.datamigration.dirapi.request.QueryProgressRequest;
import com.xdja.datamigration.dirapi.response.CancelTaskResponse;
import com.xdja.datamigration.dirapi.response.EncryptDirResponse;
import com.xdja.datamigration.dirapi.response.QueryProgressResponse;
import java.io.IOException;

public class DirectoryCryptoApi {
    private SocketWrap socketWrap;

    public DirectoryCryptoApi(String ip, int port) throws IOException, DirCryptoException {
        this.socketWrap = new SocketWrap(ip, port);
    }

    public EncryptDirResponse encryptDir(EncryptDirParams params) throws Exception {
        this.socketWrap.connection();
        if (params == null) {
            throw new DirCryptoException("EncryptDirParams is null");
        }
        String response = this.socketWrap.processing(new EncryptDirRequest(params));
        EncryptDirResponse dirResponse = new EncryptDirResponse();
        dirResponse = dirResponse.parse(response);
        this.socketWrap.close();
        return dirResponse;
    }

    public QueryProgressResponse queryProgress(String taskId) throws Exception {
        this.socketWrap.connection();
        if (null == taskId || "".equals(taskId)) {
            throw new DirCryptoException("taskId is null");
        }
        String result = this.socketWrap.processing(new QueryProgressRequest(taskId));
        QueryProgressResponse response = new QueryProgressResponse();
        response = response.parse(result);
        this.socketWrap.close();
        return response;
    }

    public CancelTaskResponse cancelTaskById(String taskId) throws Exception {
        this.socketWrap.connection();
        if (null == taskId || "".equals(taskId)) {
            throw new DirCryptoException("taskId is null");
        }
        String result = this.socketWrap.processing(new CancelTaskRequest(taskId));
        CancelTaskResponse response = new CancelTaskResponse();
        response = response.parse(result);
        this.socketWrap.close();
        return response;
    }
}

