/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.dirapi;

import com.xdja.datamigration.dirapi.IRequest;
import com.xdja.datamigration.dirapi.exception.DirCryptoException;
import com.xdja.datamigration.fileapi.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SocketWrap {
    private String ip;
    private int port;
    Socket client;

    SocketWrap(String ip, int port) throws IOException, DirCryptoException {
        boolean bool = this.validIp(ip);
        if (!bool) {
            throw new DirCryptoException("ip address is an illegal argument");
        }
        if (port < 0 || port > 65535) {
            throw new DirCryptoException("port is incorrect");
        }
        this.ip = ip;
        this.port = port;
        this.client = new Socket();
        this.client.setSoTimeout(10000);
        this.client.setReuseAddress(true);
        this.client.setKeepAlive(true);
    }

    private boolean validIp(String ipAddress) throws DirCryptoException {
        if (null == this.ip || "".equals(this.ip)) {
            throw new DirCryptoException("socket ip can not be null");
        }
        String ipReg = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pattern = Pattern.compile(ipReg);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    void connection() throws IOException {
        this.client.connect(new InetSocketAddress(this.ip, this.port), 1000);
    }

    String processing(IRequest request) throws Exception {
        int sock = this.write(request.toRequestBody());
        if (sock != 0) {
            throw new DirCryptoException("write data error");
        }
        String response = this.read();
        if (null == response || "".equals(response)) {
            throw new DirCryptoException("read data error");
        }
        return response;
    }

    private int write(byte[] requestBody) {
        try {
            String finish = "\n";
            BufferedOutputStream writer = new BufferedOutputStream(this.client.getOutputStream());
            writer.write(requestBody);
            writer.write(finish.getBytes());
            writer.flush();
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private String read() throws DirCryptoException {
        try {
            BufferedInputStream reader = new BufferedInputStream(this.client.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bufferByte = new byte[8192];
            int bufferLen = reader.read(bufferByte);
            if (bufferLen != -1) {
                out.write(bufferByte, 0, bufferLen);
                return new String(out.toByteArray());
            }
        }
        catch (Exception e) {
            throw new DirCryptoException("read data from socket error cause by:" + e.getMessage());
        }
        return "";
    }

    void close() {
        FileUtils.close(this.client);
    }
}

