/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.fileapi;

import com.xdja.datamigration.fileapi.IXdjaCryptoParameter;
import com.xdja.datamigration.fileapi.bean.XdEnvelopedData;
import com.xdja.datamigration.fileapi.exception.SingleFileCryptoException;
import com.xdja.datamigration.fileapi.param.IParamSpecDecryptByBC;
import com.xdja.datamigration.fileapi.utils.Base64Utils;
import com.xdja.datamigration.fileapi.utils.FileUtils;
import com.xdja.datamigration.fileapi.utils.XdEnvelopedDataUtils;
import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4CBCEncryptUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfSymmetricKeyHandle;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.Map;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class SingleFileCryptoApi {
    private static YunhsmSdfSDK sdfSDK;
    private SdfAlgIdSymmetric defaultEncryptKeySymmetricMode = SdfAlgIdSymmetric.SGD_SM4_ECB;
    private int defaultEncryptKeyIndex = 3;
    private X509Certificate x509Certificate;
    private SdfECCPublicKey encPublicKey;

    public SingleFileCryptoApi(IXdjaCryptoParameter cryptoParameter) throws SdfSDKException {
        this();
        if (null == cryptoParameter) {
            throw new SdfSDKException("cryptoParameter is null");
        }
        if (cryptoParameter.encryptKeyIndex() <= 0) {
            throw new SdfSDKException("cryptoParameter's Key Index is incorrect");
        }
        if (null != cryptoParameter.encryptKeySymmetricMode()) {
            this.defaultEncryptKeySymmetricMode = cryptoParameter.encryptKeySymmetricMode();
        }
        if (null != cryptoParameter.transEncryptCert()) {
            X509Certificate x509Certificate = cryptoParameter.transEncryptCert();
            this.initEncPublicKey(x509Certificate);
        }
    }

    public SingleFileCryptoApi(X509Certificate certificate) throws SdfSDKException {
        this();
        this.initEncPublicKey(certificate);
    }

    private void initEncPublicKey(X509Certificate certificate) throws SdfSDKException {
        if (certificate == null) {
            throw new SdfSDKException(" the param of certificate is null");
        }
        this.x509Certificate = certificate;
        try {
            ECPublicKey ecPublicKey = (ECPublicKey)certificate.getPublicKey();
            this.encPublicKey = SdfECCPublicKey.getInstance(ecPublicKey);
            if (this.encPublicKey == null) {
                throw new SdfSDKException(" certificate's can not be parsed public key ");
            }
        }
        catch (Exception e) {
            throw new SdfSDKException("certificate parsed public key error");
        }
    }

    private SingleFileCryptoApi() throws SdfSDKException {
        sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();
    }

    public void encryptFile(String srcPath) throws Exception {
        byte[] originContent = FileUtils.readFile2Byte(srcPath);
        byte[] encryptedContent = this.encryptData(originContent);
        FileUtils.write2File(encryptedContent, srcPath);
    }

    private byte[] padding(byte[] encryptContent) {
        byte[] realContent;
        int totalLength = encryptContent.length;
        int paddingNum = totalLength % 16;
        if (paddingNum == 0) {
            byte[] padding = new byte[16];
            Arrays.fill(padding, (byte)16);
            realContent = new byte[totalLength + 16];
            System.arraycopy(encryptContent, 0, realContent, 0, totalLength);
            System.arraycopy(padding, 0, realContent, totalLength - 1, 16);
        } else {
            int value = 16 - paddingNum;
            byte[] padding = new byte[value];
            Arrays.fill(padding, (byte)value);
            realContent = new byte[totalLength + value];
            System.arraycopy(encryptContent, 0, realContent, 0, totalLength);
            System.arraycopy(padding, 0, realContent, totalLength, value);
        }
        return realContent;
    }

    private byte[] encrypt(byte[] encryptKey, byte[] encryptContent, byte[] iv, long[] keyHandle) throws Exception {
        if (null == encryptContent || encryptContent.length <= 0) {
            throw new SingleFileCryptoException("encrypt data is null or data is empty");
        }
        int max_buffer = 4096;
        byte[] realContent = this.padding(encryptContent);
        int totalLength = realContent.length;
        if (totalLength > max_buffer) {
            int loopCount = totalLength / max_buffer;
            int rem = totalLength % max_buffer;
            byte[] cipherContent = new byte[realContent.length];
            for (int i = 0; i < loopCount; ++i) {
                byte[] buff = new byte[max_buffer];
                System.arraycopy(encryptContent, i * max_buffer, buff, 0, max_buffer);
                byte[] cipherData = sdfSDK.encrypt(keyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, buff);
                System.arraycopy(cipherData, 0, cipherContent, i * max_buffer, cipherData.length);
            }
            if (rem != 0) {
                byte[] buff = new byte[rem];
                System.arraycopy(realContent, totalLength - rem, buff, 0, rem);
                byte[] cipherData = sdfSDK.encrypt(keyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, buff);
                System.arraycopy(cipherData, 0, cipherContent, loopCount * max_buffer, cipherData.length);
            }
            sdfSDK.destroyKey(keyHandle);
            return cipherContent;
        }
        byte[] cipherData = sdfSDK.encrypt(keyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, realContent);
        sdfSDK.destroyKey(keyHandle);
        return cipherData;
    }

    public byte[] encryptData(byte[] originContent) throws Exception {
        byte[] encryptedKey = this.generateEncryptedKey();
        byte[] iv = this.generateRandom();
        long[] encryptedKeyHandle = this.generateEncryptedKeyHandle(encryptedKey);
        byte[] encryptedContent = this.encrypt(encryptedKey, originContent, iv, encryptedKeyHandle);
        XdEnvelopedData envelopedData = XdEnvelopedDataUtils.buildEnvelopedData(encryptedContent, encryptedKey, iv, this.defaultEncryptKeyIndex + "");
        return envelopedData.getEncoded();
    }

    public void decryptFile(String destPath) throws Exception {
        byte[] decodeContent = FileUtils.readFile2Byte(destPath);
        byte[] plainText = this.decryptData(decodeContent);
        FileUtils.write2File(plainText, destPath);
    }

    public byte[] decryptFile2Bytes(File encryptFile) throws Exception {
        byte[] decodeContent = FileUtils.readFile2Byte(encryptFile);
        return this.decryptData(decodeContent);
    }

    public byte[] decryptData(byte[] decodeContent) throws Exception {
        byte[] plainContent;
        if (decodeContent == null || decodeContent.length <= 0) {
            throw new SingleFileCryptoException("encrypt data or file's content is null");
        }
        Map<String, byte[]> envelopedMap = XdEnvelopedDataUtils.parseXdEnvelopedData(decodeContent);
        byte[] iv = envelopedMap.get("contentIv");
        byte[] encryptedKey = envelopedMap.get("key");
        byte[] encryptedContent = envelopedMap.get("content");
        long[] encryptedKeyHandle = this.importEncryptedKey(encryptedKey);
        int max_buffer = 4096;
        if (encryptedContent.length > max_buffer) {
            int totalLength = encryptedContent.length;
            int lastRem = totalLength % max_buffer;
            int loopCount = totalLength / max_buffer;
            plainContent = new byte[totalLength];
            for (int i = 0; i < loopCount; ++i) {
                byte[] buff = new byte[max_buffer];
                System.arraycopy(encryptedContent, i * max_buffer, buff, 0, max_buffer);
                byte[] plain = sdfSDK.decrypt(encryptedKeyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, buff);
                System.arraycopy(plain, 0, plainContent, i * max_buffer, plain.length);
            }
            if (lastRem != 0) {
                byte[] buff = new byte[lastRem];
                System.arraycopy(encryptedContent, loopCount * max_buffer, buff, 0, lastRem);
                byte[] plain = sdfSDK.decrypt(encryptedKeyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, buff);
                System.arraycopy(plain, 0, plainContent, loopCount * max_buffer, plain.length);
            }
        } else {
            plainContent = sdfSDK.decrypt(encryptedKeyHandle, SdfAlgIdSymmetric.SGD_SM4_CBC, iv, encryptedContent);
        }
        boolean isPkcs7Padding = this.isPkcs7Padding(plainContent);
        if (isPkcs7Padding) {
            int totalLength = plainContent.length;
            byte paddingValue = plainContent[plainContent.length - 1];
            plainContent = Arrays.copyOfRange(plainContent, 0, totalLength - paddingValue);
        }
        sdfSDK.destroyKey(encryptedKeyHandle);
        return plainContent;
    }

    public byte[] transEncrypt(String srcPath, boolean isEncryptedFile) throws Exception {
        if (this.encPublicKey == null) {
            throw new SdfSDKException("encPublicKey is null,ensure the certificate has been set");
        }
        byte[] fileContent = FileUtils.readFile2Byte(srcPath);
        byte[] content = isEncryptedFile ? this.decryptData(fileContent) : fileContent;
        SdfSymmetricKeyHandle symmetricKeyHandle = this.generateSymAlgWithEPK();
        byte[] encryptedKey = this.sdfECCCipher2Byte(symmetricKeyHandle.getCipherKey());
        byte[] iv = this.generateRandom();
        long[] encryptedKeyHandle = symmetricKeyHandle.getHandle();
        byte[] encryptedContent = this.encrypt(encryptedKey, content, iv, encryptedKeyHandle);
        return XdEnvelopedDataUtils.buildEnvelopedData(encryptedContent, encryptedKey, iv, this.x509Certificate).getEncoded();
    }

    private boolean isEncrypted(byte[] content) throws SingleFileCryptoException {
        Map<String, byte[]> envelopedMap = XdEnvelopedDataUtils.parseXdEnvelopedData(content);
        return !envelopedMap.isEmpty() && envelopedMap.size() > 0;
    }

    public boolean isEncrypted(String srcPath) throws Exception {
        byte[] decodeContent = FileUtils.readFile2Byte(srcPath);
        return this.isEncrypted(decodeContent);
    }

    public void release() throws Exception {
        if (sdfSDK != null) {
            sdfSDK.release();
        }
    }

    public static byte[] decryptDataByBC(byte[] envelopedData, IParamSpecDecryptByBC envelopDataDecryptParam) throws Exception {
        return SingleFileCryptoApi.dispatchEnvelopedDataDecrypt(envelopedData, envelopDataDecryptParam);
    }

    public static boolean decryptFileByBC(File file, IParamSpecDecryptByBC envelopDataDecryptParam) throws Exception {
        byte[] cipherData = FileUtils.readFile2Byte(file);
        byte[] plainData = SingleFileCryptoApi.dispatchEnvelopedDataDecrypt(cipherData, envelopDataDecryptParam);
        boolean bool = FileUtils.write2File(plainData, file);
        return bool;
    }

    public static byte[] decryptFilePathByBC(String srcPath, IParamSpecDecryptByBC envelopDataDecryptParam) throws Exception {
        byte[] cipherData = FileUtils.readFile2Byte(srcPath);
        return SingleFileCryptoApi.dispatchEnvelopedDataDecrypt(cipherData, envelopDataDecryptParam);
    }

    private static byte[] dispatchEnvelopedDataDecrypt(byte[] envelopedData, IParamSpecDecryptByBC envelopDataDecryptParam) throws Exception {
        Map<String, byte[]> envelopedDataMap = XdEnvelopedDataUtils.parseXdEnvelopedData(envelopedData);
        if (null == envelopedDataMap || envelopedDataMap.size() <= 0) {
            throw new SingleFileCryptoException("dispatchEnvelopedDataDecrypt: parseXdEnvelopedData error");
        }
        byte[] contentAlg = envelopedDataMap.get("contentAlg");
        String encryptAlg = new String(contentAlg);
        if (encryptAlg.equals(GMObjectIdentifiers.sm2encrypt.getId())) {
            long certSn = XdEnvelopedDataUtils.getCertSn(envelopedData);
            byte[] encryptedContent = envelopedDataMap.get("content");
            return SingleFileCryptoApi.sm2EnvelopedDataDecrypt(certSn, encryptedContent, envelopDataDecryptParam);
        }
        if (encryptAlg.equals(GMObjectIdentifiers.sms4_cbc.getId())) {
            return SingleFileCryptoApi.sm4EnvelopedDataDecrypt(envelopedDataMap);
        }
        throw new SingleFileCryptoException("dispatchEnvelopedDataDecrypt:decrypt alg is unsupported ");
    }

    private static byte[] sm4EnvelopedDataDecrypt(Map<String, byte[]> envelopedDataMap) throws Exception {
        byte[] encryptedContent = envelopedDataMap.get("content");
        byte[] encryptedKey = envelopedDataMap.get("key");
        byte[] iv = envelopedDataMap.get("contentIv");
        return GMSSLSM4CBCEncryptUtils.decryptByBCWithPKCS7Padding(encryptedKey, encryptedContent, iv);
    }

    private static byte[] sm2EnvelopedDataDecrypt(long sn, byte[] encryptedContent, IParamSpecDecryptByBC envelopDataDecryptParam) throws SingleFileCryptoException, IOException, InvalidCipherTextException {
        if (envelopDataDecryptParam == null) {
            throw new SingleFileCryptoException("sm2EnvelopedDataDecrypt: envelopDataDecryptParam is null");
        }
        PrivateKey privateKey = envelopDataDecryptParam.privateKey();
        X509Certificate x509Certificate = envelopDataDecryptParam.encryptCertificate();
        if (null == privateKey || null == x509Certificate) {
            throw new SingleFileCryptoException("sm2EnvelopedDataDecrypt: encryptContent's alg is sm2, privateKey or certificate is null");
        }
        BigInteger certSn = x509Certificate.getSerialNumber();
        if (certSn.longValue() != sn) {
            throw new SingleFileCryptoException("envelopedDataDecrypt:cert's sn is incorrect");
        }
        String plainContent = GMSSLSM2EncryptUtils.decryptByBC(privateKey, Base64Utils.encode(encryptedContent));
        return Base64Utils.decode(plainContent);
    }

    private byte[] sdfECCCipher2Byte(SdfECCCipher eccCipher) throws IOException {
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(eccCipher.getX(), eccCipher.getY(), eccCipher.getM(), eccCipher.getC());
        return asn1SM2Cipher.toASN1Primitive().getEncoded();
    }

    private boolean isPkcs7Padding(byte[] content) {
        boolean isPkcs7Padding = true;
        int totalLength = content.length;
        byte paddingValue = content[content.length - 1];
        if (paddingValue > 0 && paddingValue < 16) {
            byte[] padding = Arrays.copyOfRange(content, totalLength - paddingValue, totalLength);
            for (int i = 0; i < padding.length; ++i) {
                byte value = padding[i];
                if (paddingValue == value) continue;
                isPkcs7Padding = false;
            }
            return isPkcs7Padding;
        }
        return false;
    }

    private byte[] generateRandom() {
        return GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
    }

    private long[] generateEncryptedKeyHandle(byte[] encryptedKey) throws Exception {
        long[] kekHandle = sdfSDK.importKeyWithKek(this.defaultEncryptKeySymmetricMode, this.defaultEncryptKeyIndex, encryptedKey);
        return kekHandle;
    }

    private byte[] generateEncryptedKey() throws SdfSDKException {
        return sdfSDK.generateKeyWithKek(this.defaultEncryptKeySymmetricMode.getId(), this.defaultEncryptKeyIndex);
    }

    private long[] importEncryptedKey(byte[] encryptedKey) throws SdfSDKException {
        return sdfSDK.importKeyWithKek(this.defaultEncryptKeySymmetricMode, this.defaultEncryptKeyIndex, encryptedKey);
    }

    private SdfSymmetricKeyHandle generateSymAlgWithEPK() throws SdfSDKException {
        return sdfSDK.generateKeyWithEpkEccKeyHandle(this.encPublicKey);
    }
}

