/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.fileapi.bean;

import com.xdja.datamigration.fileapi.bean.XdRecipientInfo;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;

public class XdEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;

    public XdEnvelopedData(int version, ASN1Set recipientInfos, EncryptedContentInfo contentInfo) {
        this.version = new ASN1Integer(version);
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = contentInfo;
    }

    public XdEnvelopedData(byte[] data) {
        this(ASN1Sequence.getInstance(data));
    }

    public XdEnvelopedData(ASN1Sequence asn1Sequence) {
        this.version = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
        this.recipientInfos = ASN1Set.getInstance(asn1Sequence.getObjectAt(1));
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(asn1Sequence.getObjectAt(2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.recipientInfos);
        vector.add(this.encryptedContentInfo);
        return new DERSequence(vector);
    }

    public XdRecipientInfo getRecipientInfo() throws IOException {
        ASN1Sequence sequence = ASN1Sequence.getInstance(this.recipientInfos.getObjectAt(0).toASN1Primitive());
        return new XdRecipientInfo(sequence);
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }
}

