/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.fileapi.bean;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XdRecipientInfo
extends ASN1Object {
    private ASN1Integer version;
    private ASN1OctetString keyIndex;
    private AlgorithmIdentifier keyEncryptionAlgorithm;
    private ASN1OctetString encryptedKey;

    public XdRecipientInfo(int version, String keyIndex, String keyAlg, byte[] encryptedKey) {
        this.version = new ASN1Integer(version);
        this.keyIndex = new DEROctetString(keyIndex.getBytes());
        this.keyEncryptionAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier(keyAlg));
        this.encryptedKey = new DEROctetString(encryptedKey);
    }

    public XdRecipientInfo(ASN1Sequence asn1Sequence) {
        this.version = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
        this.keyIndex = DEROctetString.getInstance(asn1Sequence.getObjectAt(1));
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance(asn1Sequence.getObjectAt(2));
        this.encryptedKey = DEROctetString.getInstance(asn1Sequence.getObjectAt(3));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.keyIndex);
        vector.add(this.keyEncryptionAlgorithm);
        vector.add(this.encryptedKey);
        return new DERSequence(vector);
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey.getOctets();
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }
}

