/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.fileapi.utils;

import com.xdja.datamigration.fileapi.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class CertUtils {
    private static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_TAIL = "-----END CERTIFICATE-----";
    private static final String R = "\r";
    private static final String N = "\n";

    public static X509Certificate loadCert(String path) throws Exception {
        return CertUtils.convert2Certificate(FileUtils.readFile2Byte(path));
    }

    public static X509Certificate convert2Certificate(String cert) throws Exception {
        byte[] bytes = cert.getBytes();
        return CertUtils.convert2Certificate(bytes);
    }

    public static X509Certificate convert2Certificate(byte[] bytes) throws Exception {
        X509Certificate x509Certificate;
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(bytes);
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate x509Cert = (X509Certificate)factory.generateCertificate(inStream);
            if (x509Cert == null) {
                throw new Exception("parse certificate error");
            }
            x509Certificate = x509Cert;
        }
        catch (Exception var5) {
            try {
                throw new Exception("parse certificate error");
            }
            catch (Throwable throwable) {
                FileUtils.close(inStream);
                throw throwable;
            }
        }
        FileUtils.close(inStream);
        return x509Certificate;
    }

    public static X509Certificate convert2Certificate(File certFile) throws Exception {
        return CertUtils.convert2Certificate(FileUtils.readFile2Byte(certFile));
    }

    public static X509Certificate base642Certificate(String base64Content) throws Exception {
        base64Content = base64Content.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        base64Content = base64Content.replace(R, "").replace(N, "");
        byte[] bsCert = Base64.decode(base64Content);
        return CertUtils.convert2Certificate(bsCert);
    }

    public static PublicKey getPublicKey(X509Certificate certificate) {
        return certificate.getPublicKey();
    }

    public static boolean isRsa(X509Certificate certificate) {
        return CertUtils.isRsa(certificate.getPublicKey());
    }

    public static boolean isSm2(X509Certificate certificate) {
        return CertUtils.isSm2(certificate.getPublicKey());
    }

    public static boolean isRsa(PublicKey publicKey) {
        return "RSA".equals(publicKey.getAlgorithm());
    }

    public static boolean isSm2(PublicKey publicKey) {
        return "EC".equals(publicKey.getAlgorithm());
    }

    public static int getPublicKeyLength(X509Certificate certificate) {
        if (CertUtils.isRsa(certificate)) {
            return CertUtils.getBinaryRsaPublicKey(CertUtils.getPublicKey(certificate)).length();
        }
        if (CertUtils.isSm2(certificate)) {
            return 256;
        }
        throw new UnsupportedOperationException("certificate is not support");
    }

    public static String getBinaryRsaPublicKey(PublicKey publicKey) {
        RSAPublicKey rsa = (RSAPublicKey)publicKey;
        return rsa.getModulus().toString(2).toUpperCase();
    }

    public static String getSm2PublicKey(PublicKey publicKey) {
        ECPublicKey sm2 = (ECPublicKey)publicKey;
        return sm2.getW().getAffineX().toString(16) + "#" + sm2.getW().getAffineY().toString(16);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

