/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.fileapi.utils;

import com.xdja.datamigration.fileapi.exception.SingleFileCryptoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.bouncycastle.util.encoders.Base64;

public class FileUtils {
    public static byte[] byteMerge(byte[] ... values) {
        int totalLength = 0;
        for (int i = 0; i < values.length; ++i) {
            totalLength += values[i].length;
        }
        byte[] realBytes = new byte[totalLength];
        int countLength = 0;
        for (int i = 0; i < values.length; ++i) {
            byte[] b = values[i];
            System.arraycopy(b, 0, realBytes, countLength, b.length);
            countLength += b.length;
        }
        return realBytes;
    }

    public static boolean write2File(ArrayList<byte[]> data, String filePath) throws SingleFileCryptoException {
        byte[] realData = FileUtils.byteMerge((byte[][])data.toArray((T[])new byte[0][]));
        return FileUtils.write2File(Base64.encode(realData), new File(filePath));
    }

    public static void deleteFile(String filePath, boolean isDelete) {
        File file = new File(filePath);
        if (file.exists() && isDelete) {
            file.delete();
        }
    }

    public static byte[] readFile2Byte(String src) throws Exception {
        File file = new File(src);
        if (!file.exists() || !file.isFile()) {
            throw new SingleFileCryptoException("the path of src is incorrect");
        }
        return FileUtils.readFile2Byte(file);
    }

    public static byte[] readFile2Byte(File srcFile) throws Exception {
        byte[] byArray;
        int bufferLen = 0;
        byte[] buffer = new byte[4096];
        BufferedInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(srcFile));
            outputStream = new ByteArrayOutputStream(inputStream.available());
            while ((bufferLen = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bufferLen);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SingleFileCryptoException("read file error");
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStream);
                FileUtils.close(outputStream);
                throw throwable;
            }
        }
        FileUtils.close(inputStream);
        FileUtils.close(outputStream);
        return byArray;
    }

    public static String readFile2String(String srcPath) throws Exception {
        return FileUtils.readFile2String(new File(srcPath));
    }

    public static String readFile2String(File srcFile) throws Exception {
        byte[] bytes = FileUtils.readFile2Byte(srcFile);
        if (bytes == null || bytes.length <= 0) {
            return "";
        }
        return new String(bytes);
    }

    public static boolean write2File(byte[] data, String filePath) throws SingleFileCryptoException {
        return FileUtils.write2File(data, new File(filePath));
    }

    public static boolean write2File(byte[] data, File distFile) throws SingleFileCryptoException {
        boolean result = false;
        BufferedInputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(data));
            outputStream = new BufferedOutputStream(new FileOutputStream(distFile));
            int bufferLength = 0;
            byte[] buffer = new byte[8192];
            while ((bufferLength = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bufferLength);
            }
            outputStream.flush();
            result = true;
        }
        catch (Exception e) {
            try {
                throw new SingleFileCryptoException("write file error");
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStream);
                FileUtils.close(outputStream);
                throw throwable;
            }
        }
        FileUtils.close(inputStream);
        FileUtils.close(outputStream);
        return result;
    }

    public static boolean write2File(String data, String filePath) throws SingleFileCryptoException {
        return FileUtils.write2File(data.getBytes(), new File(filePath));
    }

    public static boolean write2File(String data, File distFile) throws SingleFileCryptoException {
        return FileUtils.write2File(data.getBytes(), distFile);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void write2FileAppend(String fileName, String content) {
        try {
            FileWriter writer = new FileWriter(fileName, true);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void write2FileAppend(File distFile, String content) {
        try {
            FileWriter writer = new FileWriter(distFile, true);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

