/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datamigration.fileapi.utils;

import com.xdja.datamigration.fileapi.bean.Sm2EnvelopedData;
import com.xdja.datamigration.fileapi.bean.XdEnvelopedData;
import com.xdja.datamigration.fileapi.bean.XdRecipientInfo;
import com.xdja.datamigration.fileapi.exception.SingleFileCryptoException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XdEnvelopedDataUtils {
    private static final String DATA = "1.2.156.10197.6.1.4.2.1";
    private static final String SM2_ENVELOPED_DATA = "1.2.156.10197.6.1.4.2.3";
    public static final String ENCRYPTED_KEY = "key";
    public static final String ENCRYPTED_KEY_ALG = "keyAlg";
    public static final String ENCRYPTED_KEY_IV = "keyAlgIv";
    public static final String ENCRYPTED_CONTENT = "content";
    public static final String ENCRYPTED_CONTENT_IV = "contentIv";
    public static final String ENCRYPTED_CONTENT_ALG = "contentAlg";

    public static XdEnvelopedData buildEnvelopedData(byte[] encryptedContent, byte[] encryptedKey, byte[] iv, String hsmKeyIndex) throws Exception {
        XdRecipientInfo recipientInfo = XdEnvelopedDataUtils.buildRecipientInfo(encryptedKey, hsmKeyIndex);
        DERSet recipientInfos = new DERSet(recipientInfo);
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier(DATA);
        DEROctetString IV = new DEROctetString(iv);
        AlgorithmIdentifier contentEncryptionAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc, IV);
        DEROctetString content = new DEROctetString(encryptedContent);
        EncryptedContentInfo contentInfo = new EncryptedContentInfo(contentType, contentEncryptionAlgorithm, content);
        return new XdEnvelopedData(5, recipientInfos, contentInfo);
    }

    public static Sm2EnvelopedData buildEnvelopedData(byte[] encryptedContent, byte[] encryptedKey, byte[] iv, X509Certificate x509Certificate) throws Exception {
        IssuerAndSerialNumber issuerAndSerialNumber = XdEnvelopedDataUtils.buildIssuerAndSerialNumber(x509Certificate);
        RecipientIdentifier recipientIdentifier = XdEnvelopedDataUtils.buildRecipientIdentifier(issuerAndSerialNumber);
        DEROctetString encryptedKeyValue = new DEROctetString(encryptedKey);
        AlgorithmIdentifier encryptedKeyAlgOid = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.3"));
        KeyTransRecipientInfo keyTransRecipientInfo = XdEnvelopedDataUtils.buildKeyTransRecipientInfo(recipientIdentifier, encryptedKeyAlgOid, encryptedKeyValue);
        RecipientInfo recipientInfo = XdEnvelopedDataUtils.buildRecipientInfo(keyTransRecipientInfo);
        DERSet recipientInfos = new DERSet(recipientInfo);
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier(DATA);
        AlgorithmIdentifier contentEncryptionAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc, new DEROctetString(iv));
        EncryptedContentInfo contentInfo = new EncryptedContentInfo(contentType, contentEncryptionAlgorithm, new DEROctetString(encryptedContent));
        XdEnvelopedData envelopedData = new XdEnvelopedData(1, recipientInfos, contentInfo);
        Sm2EnvelopedData sm2EnvelopedData = new Sm2EnvelopedData(SM2_ENVELOPED_DATA, envelopedData);
        return sm2EnvelopedData;
    }

    private static IssuerAndSerialNumber buildIssuerAndSerialNumber(X509Certificate x509Certificate) {
        return new IssuerAndSerialNumber(X500Name.getInstance(x509Certificate.getIssuerDN()), x509Certificate.getSerialNumber());
    }

    private static RecipientIdentifier buildRecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new RecipientIdentifier(issuerAndSerialNumber);
    }

    private static KeyTransRecipientInfo buildKeyTransRecipientInfo(RecipientIdentifier recipientIdentifier, AlgorithmIdentifier encryptAlgOid, ASN1OctetString encryptedKeyValue) {
        return new KeyTransRecipientInfo(recipientIdentifier, encryptAlgOid, encryptedKeyValue);
    }

    private static RecipientInfo buildRecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        return new RecipientInfo(keyTransRecipientInfo);
    }

    private static XdRecipientInfo buildRecipientInfo(byte[] encryptedKey, String hsmKeyIndex) throws Exception {
        return new XdRecipientInfo(5, hsmKeyIndex, GMObjectIdentifiers.sms4_ecb.getId(), encryptedKey);
    }

    public static Map<String, byte[]> parseXdEnvelopedData(byte[] content) throws SingleFileCryptoException {
        HashMap<String, byte[]> envelopDataMap = new HashMap<String, byte[]>();
        EnvelopedData envelopedData = EnvelopedData.getInstance(content);
        if (envelopedData == null) {
            throw new SingleFileCryptoException("parse EnvelopData error");
        }
        RecipientInfo recipientInfo = RecipientInfo.getInstance(envelopedData.getRecipientInfos().getObjectAt(0).toASN1Primitive());
        KeyTransRecipientInfo keyTransRecipientInfo = KeyTransRecipientInfo.getInstance(recipientInfo.getInfo());
        AlgorithmIdentifier keyEncryptionAlg = keyTransRecipientInfo.getKeyEncryptionAlgorithm();
        if (keyTransRecipientInfo == null) {
            throw new SingleFileCryptoException("parseXdEnvelopedData: keyTransRecipientInfo is null");
        }
        ASN1OctetString encryptedKeyOctetString = keyTransRecipientInfo.getEncryptedKey();
        if (encryptedKeyOctetString == null) {
            throw new SingleFileCryptoException("parseXdEnvelopedData: encryptedKeyOctetString is null");
        }
        byte[] encryptedKey = encryptedKeyOctetString.getOctets();
        ASN1ObjectIdentifier encryptedKeyAlgOid = keyEncryptionAlg.getAlgorithm();
        if (encryptedKeyAlgOid == null) {
            throw new SingleFileCryptoException("parseXdEnvelopedData: encryptedKeyAlgOid is null");
        }
        byte[] encryptedKeyAlg = encryptedKeyAlgOid.getId().getBytes();
        envelopDataMap.put(ENCRYPTED_KEY, encryptedKey);
        envelopDataMap.put(ENCRYPTED_KEY_ALG, encryptedKeyAlg);
        ASN1Encodable ivParameter = keyEncryptionAlg.getParameters();
        if (ivParameter == null) {
            envelopDataMap.put(ENCRYPTED_KEY_IV, new byte[0]);
        } else {
            byte[] encryptedKeyIv = DEROctetString.getInstance(ivParameter.toASN1Primitive()).getOctets();
            envelopDataMap.put(ENCRYPTED_KEY_IV, encryptedKeyIv);
        }
        EncryptedContentInfo contentInfo = envelopedData.getEncryptedContentInfo();
        byte[] encryptedContent = contentInfo.getEncryptedContent().getOctets();
        envelopDataMap.put(ENCRYPTED_CONTENT, encryptedContent);
        AlgorithmIdentifier algorithmIdentifier = contentInfo.getContentEncryptionAlgorithm();
        ASN1ObjectIdentifier contentAlg = ASN1ObjectIdentifier.getInstance(algorithmIdentifier.getAlgorithm());
        envelopDataMap.put(ENCRYPTED_CONTENT_ALG, contentAlg.getId().getBytes());
        ASN1OctetString contentIv = DEROctetString.getInstance(algorithmIdentifier.getParameters());
        envelopDataMap.put(ENCRYPTED_CONTENT_IV, contentIv.getOctets());
        return envelopDataMap;
    }

    public static long getCertSn(byte[] content) {
        EnvelopedData envelopedData = EnvelopedData.getInstance(content);
        RecipientInfo recipientInfo = RecipientInfo.getInstance(envelopedData.getRecipientInfos().getObjectAt(0).toASN1Primitive());
        KeyTransRecipientInfo keyTransRecipientInfo = KeyTransRecipientInfo.getInstance(recipientInfo.getInfo());
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
        return issuerAndSerialNumber.getSerialNumber().getValue().longValue();
    }
}

