/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.asn1.crypto;

import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1SM2Cipher
extends ASN1Object {
    private static Logger logger = LoggerFactory.getLogger(ASN1SM2Cipher.class);
    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private ASN1OctetString hash;
    private ASN1OctetString cipherText;

    public static ASN1SM2Cipher getInstance(Object o) {
        if (o instanceof ASN1SM2Cipher) {
            return (ASN1SM2Cipher)o;
        }
        if (o != null) {
            return new ASN1SM2Cipher(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1SM2Cipher(ASN1Sequence sm2Asn1Sequence) {
        Enumeration e = sm2Asn1Sequence.getObjects();
        this.xCoordinate = ASN1Integer.getInstance(e.nextElement());
        this.yCoordinate = ASN1Integer.getInstance(e.nextElement());
        this.hash = ASN1OctetString.getInstance(e.nextElement());
        this.cipherText = ASN1OctetString.getInstance(e.nextElement());
    }

    public ASN1SM2Cipher(ASN1Integer xCoordinate, ASN1Integer yCoordinate, ASN1OctetString hash, ASN1OctetString cipherText) {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.hash = hash;
        this.cipherText = cipherText;
    }

    public ASN1SM2Cipher(byte[] x, byte[] y, byte[] hash, byte[] cipherText) {
        this.xCoordinate = new ASN1Integer(BigIntegers.fromUnsignedByteArray(x));
        this.yCoordinate = new ASN1Integer(BigIntegers.fromUnsignedByteArray(y));
        this.hash = new DEROctetString(hash);
        this.cipherText = new DEROctetString(cipherText);
    }

    public BigInteger getxCoordinate() {
        return this.xCoordinate.getPositiveValue();
    }

    public BigInteger getyCoordinate() {
        return this.yCoordinate.getPositiveValue();
    }

    public byte[] getHash() {
        return this.hash.getOctets();
    }

    public byte[] getCipherText() {
        return this.cipherText.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.xCoordinate);
        vector.add(this.yCoordinate);
        vector.add(this.hash);
        vector.add(this.cipherText);
        return new DERSequence(vector);
    }

    public static ASN1SM2Cipher convertToASN1(ECPublicKey publicKey, byte[] ciphertext, int digestSize) throws IOException {
        ECKeyParameters ecKeyParameters = (ECKeyParameters)GMSSLX509Utils.convertECPublicKeyParameters(publicKey);
        ECCurve curve = ecKeyParameters.getParameters().getCurve();
        return ASN1SM2Cipher.convertToASN1(curve, ciphertext, digestSize);
    }

    public static ASN1SM2Cipher convertToASN1(String stdName, byte[] ciphertext, int digestSize) {
        ECCurve ecCurve = GMSSLECUtils.getECCurve(stdName);
        return ASN1SM2Cipher.convertToASN1(ecCurve, ciphertext, digestSize);
    }

    public static ASN1SM2Cipher convertToASN1(ECCurve curve, byte[] ciphertext, int digestSize) {
        int inOff = 0;
        int curveLength = (curve.getFieldSize() + 7) / 8;
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(ciphertext, inOff, c1, 0, c1.length);
        ECPoint c1P = curve.decodePoint(c1);
        byte[] xb = c1P.getXCoord().getEncoded();
        byte[] yb = c1P.getYCoord().getEncoded();
        int plaintextLength = ciphertext.length - c1.length - digestSize;
        byte[] c2 = new byte[plaintextLength];
        System.arraycopy(ciphertext, c1.length, c2, 0, plaintextLength);
        byte[] c3 = new byte[digestSize];
        System.arraycopy(ciphertext, ciphertext.length - digestSize, c3, 0, digestSize);
        return new ASN1SM2Cipher(xb, yb, c3, c2);
    }

    public static byte[] pieceC1C2C3(byte[] x, byte[] y, byte[] hash, byte[] cipher) {
        int len = 1 + x.length + y.length + hash.length + cipher.length;
        byte[] ciphertext = new byte[len];
        ciphertext[0] = 4;
        System.arraycopy(x, 0, ciphertext, 1, x.length);
        System.arraycopy(y, 0, ciphertext, 1 + x.length, y.length);
        System.arraycopy(cipher, 0, ciphertext, 1 + x.length + y.length, cipher.length);
        System.arraycopy(hash, 0, ciphertext, 1 + x.length + y.length + cipher.length, hash.length);
        return ciphertext;
    }

    public static byte[][] splitC1C2C3(int curveLen, int hashLen, byte[] cipher) {
        int xyLen = (curveLen - 1) / 2;
        byte[] x = new byte[xyLen];
        byte[] y = new byte[xyLen];
        byte[] c = new byte[cipher.length - curveLen - hashLen];
        byte[] hash = new byte[hashLen];
        System.arraycopy(cipher, 1, x, 0, x.length);
        System.arraycopy(cipher, 1 + x.length, y, 0, y.length);
        System.arraycopy(cipher, 1 + x.length + y.length, c, 0, c.length);
        System.arraycopy(cipher, 1 + x.length + y.length + c.length, hash, 0, hash.length);
        return new byte[][]{x, y, c, hash};
    }
}

