/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLBCCipherUtils {
    public static final String AES_ECB_NoPadding = "AES/ECB/NoPadding";
    public static final String AES_ECB_PKCS5Padding = "AES/ECB/PKCS5Padding";
    public static final String AES_ECB_PKCS7Padding = "AES/ECB/PKCS7Padding";
    public static final String AES_CBC_NOPADDING = "AES/CBC/NoPadding";
    public static final String AES_CBC_PKCS5Padding = "AES/CBC/PKCS5Padding";
    public static final String AES_CBC_PKCS7Padding = "AES/CBC/PKCS7Padding";
    public static final String ECIES = "ECIES";

    public static byte[] encryptData(String algorithm, PublicKey publicKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptData(String algorithm, PrivateKey privateKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] symmetricCBCEncrypt(String algorithm, byte[] key, byte[] data, byte[] initIV) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
        cipher.init(1, (Key)keySpec, new IvParameterSpec(initIV));
        return cipher.doFinal(data);
    }

    public static byte[] symmetricECBEncrypt(String algorithm, byte[] key, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
        cipher.init(1, keySpec);
        return cipher.doFinal(data);
    }

    public static byte[] symmetricCBCDecrypt(String algorithm, byte[] key, byte[] data, byte[] initIV) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
        cipher.init(2, (Key)keySpec, new IvParameterSpec(initIV));
        return cipher.doFinal(data);
    }

    public static byte[] symmetricECBDecrypt(String algorithm, byte[] key, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
        cipher.init(2, keySpec);
        return cipher.doFinal(data);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

