/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.HexDumpEncoder;

public class GMSSLByteArrayUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLByteArrayUtils.class.getName());

    public static byte[] hexDecode(String hexData) {
        return Hex.decode(hexData);
    }

    public static String hexEncode(byte[] data) {
        return Hex.toHexString(data);
    }

    public static String hexEncode(BigInteger data) {
        return GMSSLByteArrayUtils.hexEncode(GMSSLByteArrayUtils.asUnsignedByteArray32(data));
    }

    public static void printHexBinary(Logger log, String message, byte[] data) {
        GMSSLByteArrayUtils.printHexBinary(log, message, data, false);
    }

    public static void printHexBinary(Logger log, String message, byte[] data, boolean isError) {
        String msg = data == null ? message + " data : null!" : message + " >> Hex len : " + data.length + " data : " + GMSSLByteArrayUtils.hexEncode(data) + " \n" + GMSSLByteArrayUtils.hexDumpEncoder(data);
        if (log != null) {
            if (isError) {
                log.error(msg);
            } else if (log.isDebugEnabled()) {
                log.debug(msg);
            }
        } else if (isError) {
            logger.error(msg);
        } else if (logger.isDebugEnabled()) {
            logger.debug(msg);
        }
    }

    public static String hexDumpEncoder(byte[] data) {
        HexDumpEncoder encoder = new HexDumpEncoder();
        return encoder.encodeBuffer(data);
    }

    public static byte[] base64Decode(String base64Data) {
        return Base64.decode(base64Data);
    }

    public static String base64Encode(byte[] data) {
        return Base64.toBase64String(data);
    }

    public static void printBase64Binary(Logger log, String message, byte[] data) {
        if (log != null) {
            log.debug(message + " >> Base64 len : " + data.length + " data : " + GMSSLByteArrayUtils.base64Encode(data));
        } else {
            logger.debug(message + " >> Base64 len : " + data.length + " data : " + GMSSLByteArrayUtils.base64Encode(data));
        }
    }

    public static String asciiToHex(String asciiValue) {
        char[] chars = asciiValue.toCharArray();
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            hex.append(Integer.toHexString(chars[i]));
        }
        return hex.toString();
    }

    public static String hexToASCII(String hexValue) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexValue.length(); i += 2) {
            String str = hexValue.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static boolean isEqual(byte[] arr1, byte[] arr2) {
        int i;
        if (arr1.length != arr2.length) {
            return false;
        }
        boolean flag1 = true;
        boolean flag2 = true;
        for (i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            flag1 = false;
        }
        if (!flag1) {
            for (i = 0; i < arr1.length; ++i) {
                if (arr1[i] == arr2[arr1.length - 1 - i]) continue;
                flag2 = false;
            }
        }
        return flag1 || flag2;
    }

    public static byte[] transformByteArrayTo32InHead(byte[] from) {
        return GMSSLByteArrayUtils.transformByteArrayInHead(from, 32);
    }

    public static byte[] transformByteArrayInHead(byte[] from, int len) {
        if (from.length > len) {
            return GMSSLByteArrayUtils.filterByteArrayZeroInHead(from, len);
        }
        if (from.length < len) {
            return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(from, len);
        }
        return from;
    }

    public static byte[] transformByteArrayTo32InFoot(byte[] from) {
        return GMSSLByteArrayUtils.transformByteArrayToInFoot(from, 32);
    }

    public static byte[] transformByteArrayToInFoot(byte[] from, int len) {
        if (from.length > len) {
            return GMSSLByteArrayUtils.filterByteArrayZeroInFoot(from, len);
        }
        if (from.length < len) {
            return GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(from, len);
        }
        return from;
    }

    public static byte[] fillByteArrayWithZeroInFoot(byte[] ss) {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(ss, 64);
    }

    public static byte[] fillByteArrayWithZeroInFoot(byte[] ss, int len) {
        byte[] bs = new byte[len];
        Arrays.fill(bs, (byte)0);
        System.arraycopy(ss, 0, bs, 0, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInFoot(byte[] ss) {
        return GMSSLByteArrayUtils.filterByteArrayZeroInFoot(ss, 32);
    }

    public static byte[] filterByteArrayZeroInFoot(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, 0, bs, 0, len);
        return bs;
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss) {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(ss, 64);
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss, int len) {
        if (ss.length == len) {
            return ss;
        }
        byte[] bs = new byte[len];
        Arrays.fill(bs, (byte)0);
        System.arraycopy(ss, 0, bs, len - ss.length, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss) {
        return GMSSLByteArrayUtils.filterByteArrayZeroInHead(ss, 32);
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, ss.length - len, bs, 0, len);
        return bs;
    }

    public static boolean compareHexBinary(Logger log, String message, String hexData, byte[] data) {
        boolean equals = Arrays.equals(GMSSLByteArrayUtils.hexDecode(hexData), data);
        String s = GMSSLByteArrayUtils.hexEncode(data);
        if (log != null) {
            log.debug("compareHexBinary >> " + equals + " len : " + data.length + " " + message + " Hex data : " + s);
        } else {
            logger.debug("compareHexBinary >> " + equals + " len : " + data.length + " " + message + " Hex data : " + s);
        }
        return equals;
    }

    public static byte[] asUnsignedByteArray32(BigInteger value) {
        return BigIntegers.asUnsignedByteArray(32, value);
    }

    public static byte[] asUnsignedByteArray(BigInteger value, int length) {
        return BigIntegers.asUnsignedByteArray(length, value);
    }

    public static byte[] subByteArray(byte[] data, int length) {
        byte[] out = new byte[length];
        System.arraycopy(data, 0, out, 0, length);
        return out;
    }

    public static byte[] mergeByteArray(byte[] var1, byte[] var2) {
        byte[] out = new byte[var1.length + var2.length];
        System.arraycopy(var1, 0, out, 0, var1.length);
        System.arraycopy(var2, 0, out, var1.length, var2.length);
        return out;
    }

    public static byte[] changeByteArrayLength(byte[] bb, int len) {
        if (bb.length == len) {
            return bb;
        }
        if (bb.length < len) {
            return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(bb, len);
        }
        return GMSSLByteArrayUtils.filterByteArrayZeroInHead(bb, len);
    }
}

