/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLECUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLECUtils.class);
    public static final int ECC_KEY_BITS = 256;
    public static final String ECC_ALGORITHM_NAME = "EC";
    public static final ASN1ObjectIdentifier sm2p256v1;
    public static final ASN1ObjectIdentifier nistp256r1;
    public static final String SM2p256;
    public static final String NISTp256;

    public static KeyPair generateKeyPair(String stdName) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(ECC_ALGORITHM_NAME, "BC");
        kpGen.initialize(new ECGenParameterSpec(stdName), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static ECCurve getECCurve(ECPublicKey publicKey) {
        return GMSSLECUtils.getECParameterSpec(publicKey).getCurve();
    }

    public static ECParameterSpec getECParameterSpec(ECPublicKey publicKey) {
        return EC5Util.convertSpec(publicKey.getParams(), false);
    }

    public static ECCurve getECCurve(ASN1ObjectIdentifier oid) {
        return GMSSLECUtils.getX9ECParameters(oid).getCurve();
    }

    public static ECCurve getECCurve(String stdName) {
        return GMSSLECUtils.getX9ECParameters(stdName).getCurve();
    }

    public static X9ECParameters getX9ECParameters(ASN1ObjectIdentifier oid) {
        return ECUtil.getNamedCurveByOid(oid);
    }

    public static X9ECParameters getX9ECParameters(String stdName) {
        return ECUtil.getNamedCurveByName(stdName);
    }

    public static byte[] derEncodeSignature(byte[] r, byte[] s) throws IOException {
        return GMSSLECUtils.derEncodeSignature(BigIntegers.fromUnsignedByteArray(r), BigIntegers.fromUnsignedByteArray(s));
    }

    public static byte[] derEncodeSignature(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(r));
        v.add(new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }

    public static byte[][] derDecodeSignature(byte[] signature) throws IOException {
        BigInteger[] bigIntegers = GMSSLECUtils.derDecodeSign(signature);
        if (bigIntegers == null) {
            return null;
        }
        return new byte[][]{BigIntegers.asUnsignedByteArray(bigIntegers[0]), BigIntegers.asUnsignedByteArray(bigIntegers[1])};
    }

    public static BigInteger[] derDecodeSign(byte[] signature) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(signature));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = GMSSLECUtils.derEncodeSignature(r, s = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual(expectedEncoding, signature)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }

    public static PublicKey convertECPublicKey(byte[] x, byte[] y, String stdName) throws Exception {
        if (x.length != 32 || y.length != 32) {
            throw new Exception("x or y length error x: " + x.length + " y: " + y.length);
        }
        return GMSSLECUtils.convertECPublicKey(BigIntegers.fromUnsignedByteArray(x), BigIntegers.fromUnsignedByteArray(y), stdName);
    }

    public static PublicKey convertECPublicKey(BigInteger x, BigInteger y, String stdName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint point = curve.createPoint(x, y);
        return GMSSLECUtils.convertECPublicKey(ecParameterSpec, point, stdName);
    }

    public static PublicKey convertECPublicKey(ECParameterSpec ecParameterSpec, ECPoint ecPoint, String stdName) throws Exception {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
        return new BCECPublicKey(stdName, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PrivateKey convertECPrivateKey(byte[] s, String stdName) throws Exception {
        if (s.length != 32) {
            throw new Exception("s length error s: " + s.length);
        }
        return GMSSLECUtils.convertECPrivateKey(BigIntegers.fromUnsignedByteArray(s), stdName);
    }

    public static PrivateKey convertECPrivateKey(BigInteger s, String stdName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ECC_ALGORITHM_NAME, "BC");
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static KeyPair convertECKeyPair(byte[] s, String stdName) throws Exception {
        if (s.length != 32) {
            throw new Exception("s length error s: " + s.length);
        }
        return GMSSLECUtils.convertECKeyPair(BigIntegers.fromUnsignedByteArray(s), stdName);
    }

    public static KeyPair convertECKeyPair(BigInteger s, String stdName) throws Exception {
        return GMSSLECUtils.convertKeyPair(s, stdName);
    }

    public static KeyPair convertECKeyPair(PrivateKey key, String stdName) throws Exception {
        PublicKey publicKey = GMSSLECUtils.convertECPublicKey(key, stdName);
        return new KeyPair(publicKey, key);
    }

    public static PublicKey convertECPublicKey(PrivateKey key, String stdName) throws Exception {
        return GMSSLECUtils.convertPublicKey(key, stdName);
    }

    public static PublicKey convertECPublicKey(SubjectPublicKeyInfo info) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = new DefaultJcaJceHelper().createKeyFactory(info.getAlgorithm().getAlgorithm().getId());
        return keyFactory.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
    }

    public static PublicKey convertPublicKeyBitString(String base64, String stdName) throws Exception {
        return GMSSLECUtils.convertPublicKeyBitString(GMSSLByteArrayUtils.base64Decode(base64), stdName);
    }

    public static PublicKey convertPublicKeyBitString(byte[] data, String stdName) throws Exception {
        int digestLen = 32;
        byte[] x = new byte[digestLen];
        System.arraycopy(data, 1, x, 0, digestLen);
        byte[] y = new byte[digestLen];
        System.arraycopy(data, digestLen + 1, y, 0, digestLen);
        return GMSSLECUtils.convertPublicKey(x, y, stdName);
    }

    public static String convertBitStringPublicKey(ECPublicKey publicKey) throws Exception {
        return GMSSLECUtils.convertBitStringPublicKey(publicKey.getW().getAffineX(), publicKey.getW().getAffineY());
    }

    public static String convertBitStringPublicKey(BigInteger x, BigInteger y) throws Exception {
        return GMSSLECUtils.convertBitStringPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray32(x), GMSSLByteArrayUtils.asUnsignedByteArray32(y));
    }

    public static String convertBitStringPublicKey(byte[] x, byte[] y) throws Exception {
        if (x.length != 32 || y.length != 32) {
            throw new Exception("x or y length error x: " + x.length + " y: " + y.length);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(4);
        outputStream.write(x);
        outputStream.write(y);
        return GMSSLByteArrayUtils.base64Encode(outputStream.toByteArray());
    }

    public static byte[] encodePublicKey(boolean compressed, PublicKey publicKey) throws Exception {
        BCECPublicKey ecPublicKey = (BCECPublicKey)publicKey;
        ECPoint q = ecPublicKey.getQ();
        return q.getEncoded(compressed);
    }

    public static int checkPublicKeyY0Y1(PublicKey publicKey) {
        BCECPublicKey ecPublicKey = (BCECPublicKey)publicKey;
        return GMSSLECUtils.checkPublicKeyY0Y1(ecPublicKey.getW().getAffineY());
    }

    public static int checkPublicKeyY0Y1(BigInteger bigInteger) {
        boolean is1 = bigInteger.testBit(0);
        if (is1) {
            return 3;
        }
        return 2;
    }

    public static PublicKey decodePublicKey(byte[] encode, String stdName) throws Exception {
        return GMSSLECUtils.convertPublicKey(encode, stdName);
    }

    public static PublicKey convertPublicKey(int yTilde, byte[] publicKey, String stdName) throws Exception {
        if (yTilde != 2 && yTilde != 3 && yTilde != 4) {
            throw new Exception("yTilde must be 2 or 3 or 4 error yTilde: " + yTilde);
        }
        if (publicKey.length != 32 && publicKey.length != 64) {
            throw new Exception("publicKey length error publicKey: " + publicKey.length);
        }
        byte[] encode = new byte[publicKey.length + 1];
        System.arraycopy(yTilde, 0, encode, 1, publicKey.length);
        return GMSSLECUtils.convertPublicKey(encode, stdName);
    }

    public static PublicKey convertPublicKey(byte[] encoded, String stdName) throws Exception {
        boolean compressed;
        boolean uncompressed;
        byte type = encoded[0];
        boolean bl = uncompressed = type == 4;
        if (uncompressed && encoded.length != 65) {
            throw new Exception("encoded length error x: " + encoded.length);
        }
        boolean bl2 = compressed = type == 2 || type == 3;
        if (compressed && encoded.length != 33) {
            throw new Exception("encoded length error x: " + encoded.length);
        }
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint ecPoint = curve.decodePoint(encoded);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
        return new BCECPublicKey(stdName, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PublicKey convertPublicKey(byte[] x, byte[] y, String stdName) throws Exception {
        if (x.length != 32 || y.length != 32) {
            throw new Exception("x or y length error x: " + x.length + " y: " + y.length);
        }
        return GMSSLECUtils.convertPublicKey(BigIntegers.fromUnsignedByteArray(x), BigIntegers.fromUnsignedByteArray(y), stdName);
    }

    public static PublicKey convertPublicKey(BigInteger x, BigInteger y, String stdName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint point = curve.createPoint(x, y);
        return GMSSLECUtils.convertPublicKey(ecParameterSpec, point, stdName);
    }

    public static PublicKey convertPublicKey(ECParameterSpec ecParameterSpec, ECPoint ecPoint, String stdName) throws Exception {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
        return new BCECPublicKey(stdName, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PrivateKey convertPrivateKey(byte[] s, String stdName) throws Exception {
        if (s.length != 32) {
            throw new Exception("s length error s: " + s.length);
        }
        return GMSSLECUtils.convertPrivateKey(BigIntegers.fromUnsignedByteArray(s), stdName);
    }

    public static PrivateKey convertPrivateKey(BigInteger s, String stdName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ECC_ALGORITHM_NAME, "BC");
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static KeyPair convertKeyPair(byte[] s, String stdName) throws Exception {
        if (s.length != 32) {
            throw new Exception("s length error s: " + s.length);
        }
        return GMSSLECUtils.convertKeyPair(BigIntegers.fromUnsignedByteArray(s), stdName);
    }

    public static KeyPair convertKeyPair(BigInteger s, String stdName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        KeyFactory keyFactory = KeyFactory.getInstance(ECC_ALGORITHM_NAME, "BC");
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, ecParameterSpec);
        ECPrivateKey privateKey = (ECPrivateKey)keyFactory.generatePrivate(privateKeySpec);
        BigInteger s1 = privateKey.getS();
        ECPoint q = ecParameterSpec.getG().multiply(s1);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(q, ecParameterSpec);
        PublicKey publicKey = keyFactory.generatePublic(pubSpec);
        return new KeyPair(publicKey, privateKey);
    }

    public static KeyPair convertKeyPair(PrivateKey key, String stdName) throws Exception {
        PublicKey publicKey = GMSSLECUtils.convertPublicKey(key, stdName);
        return new KeyPair(publicKey, key);
    }

    public static PublicKey convertPublicKey(PrivateKey key, String stdName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        KeyFactory keyFactory = KeyFactory.getInstance(ECC_ALGORITHM_NAME, "BC");
        ECPrivateKey privateKey = (ECPrivateKey)key;
        BigInteger s1 = privateKey.getS();
        ECPoint q = ecParameterSpec.getG().multiply(s1);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(q, ecParameterSpec);
        return keyFactory.generatePublic(pubSpec);
    }

    public static PublicKey convertPublicKey(SubjectPublicKeyInfo info) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = new DefaultJcaJceHelper().createKeyFactory(info.getAlgorithm().getAlgorithm().getId());
        return keyFactory.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
    }

    public static PrivateKey convertPrivateKeyEncode(byte[] privateKeyInfo) throws Exception {
        PrivateKeyInfo instance = PrivateKeyInfo.getInstance(privateKeyInfo);
        return GMSSLECUtils.convertPrivateKey(instance);
    }

    public static PrivateKey convertPrivateKey(PrivateKeyInfo info) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(info.getPrivateKeyAlgorithm().getAlgorithm().getId(), "BC");
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(info.getEncoded()));
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        sm2p256v1 = GMObjectIdentifiers.sm2p256v1;
        nistp256r1 = SECObjectIdentifiers.secp256r1;
        SM2p256 = GMNamedCurves.getName(sm2p256v1);
        NISTp256 = NISTNamedCurves.getName(nistp256r1);
    }
}

