/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCCipherUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;

public class GMSSLRSAUtils {
    public static final String RSA_ALGORITHM_NAME = "RSA";

    public static KeyPair generateRSAKeyPair(int keySize) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(RSA_ALGORITHM_NAME, "BC");
        kpGen.initialize(keySize);
        return kpGen.generateKeyPair();
    }

    public static PublicKey convertRSAPublicKey(SubjectPublicKeyInfo info) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = new DefaultJcaJceHelper().createKeyFactory(info.getAlgorithm().getAlgorithm().getId());
        return keyFactory.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
    }

    public static RSAPublicKey convertRSAPublicKey(byte[] m) throws Exception {
        return GMSSLRSAUtils.convertRSAPublicKey(BigIntegers.fromUnsignedByteArray(m), BigInteger.valueOf(65537L));
    }

    public static RSAPublicKey convertRSAPublicKey(byte[] m, byte[] e) throws Exception {
        return GMSSLRSAUtils.convertRSAPublicKey(BigIntegers.fromUnsignedByteArray(m), BigIntegers.fromUnsignedByteArray(e));
    }

    public static RSAPublicKey convertRSAPublicKey(BigInteger m, BigInteger e) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_NAME, "BC");
        RSAPublicKeySpec spec1 = new RSAPublicKeySpec(m, e);
        return (RSAPublicKey)keyFactory.generatePublic(spec1);
    }

    public static RSAPrivateKey convertRSAPrivateKeyWithOutAlgID(byte[] encodeWithOutAlgID) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(PKCSObjectIdentifiers.rsaEncryption.getId(), "BC");
        return (RSAPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodeWithOutAlgID));
    }

    public static RSAPrivateKey convertRSAPrivateKey(byte[] m, byte[] e, byte[] d, byte[][] prime, byte[][] pexp, byte[] coef) throws Exception {
        return GMSSLRSAUtils.convertRSAPrivateKey(BigIntegers.fromUnsignedByteArray(m), BigIntegers.fromUnsignedByteArray(e), BigIntegers.fromUnsignedByteArray(d), BigIntegers.fromUnsignedByteArray(prime[0]), BigIntegers.fromUnsignedByteArray(prime[1]), BigIntegers.fromUnsignedByteArray(pexp[0]), BigIntegers.fromUnsignedByteArray(pexp[1]), BigIntegers.fromUnsignedByteArray(coef));
    }

    public static RSAPrivateKey convertRSAPrivateKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger PrimeExponentP, BigInteger PrimeExponentQ, BigInteger crtCoefficient) throws Exception {
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, PrimeExponentP, PrimeExponentQ, crtCoefficient);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_NAME, "BC");
        return (RSAPrivateKey)keyFactory.generatePrivate(spec);
    }

    public static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }

    public static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        RSAPrivateKey k = key;
        return new RSAKeyParameters(true, k.getModulus(), k.getPrivateExponent());
    }

    public static byte[] generateSignature(String algorithm, PrivateKey privateKey, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        return GMSSLBCSignUtils.generateSignature(algorithm, privateKey, data);
    }

    public static boolean verifySignature(String algorithm, PublicKey publicKey, byte[] data, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        return GMSSLBCSignUtils.verifySignature(algorithm, publicKey, data, signature);
    }

    public static byte[] encryptData(PublicKey publicKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLBCCipherUtils.encryptData(RSA_ALGORITHM_NAME, publicKey, data);
    }

    public static byte[] encryptDataPKCS1Padding(PublicKey publicKey, byte[] data) throws InvalidCipherTextException {
        RSAKeyParameters keyParameter = GMSSLRSAUtils.generatePublicKeyParameter((RSAPublicKey)publicKey);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(true, keyParameter);
        return encoding.processBlock(data, 0, data.length);
    }

    public static byte[] decryptData(PrivateKey privateKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLBCCipherUtils.decryptData(RSA_ALGORITHM_NAME, privateKey, data);
    }

    public static byte[] decryptDataPKCS1Padding(PrivateKey privateKey, byte[] data) throws InvalidCipherTextException {
        RSAKeyParameters keyParameter = GMSSLRSAUtils.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(false, keyParameter);
        return encoding.processBlock(data, 0, data.length);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

