/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;

public enum SdfAeadType {
    AES_CCM_128(NISTObjectIdentifiers.id_aes128_CCM, "AES_CCM_128"),
    AES_CCM_192(NISTObjectIdentifiers.id_aes192_CCM, "AES_CCM_192"),
    AES_CCM_256(NISTObjectIdentifiers.id_aes256_CCM, "AES_CCM_256");

    private ASN1ObjectIdentifier aid;
    private String name;

    private SdfAeadType(ASN1ObjectIdentifier aid, String name) {
        this.aid = aid;
        this.name = name;
    }

    public ASN1ObjectIdentifier getAid() {
        return this.aid;
    }

    public String getName() {
        return this.name;
    }

    public static SdfAeadType convertSdfAeadType(ASN1ObjectIdentifier aid) {
        if (NISTObjectIdentifiers.id_aes128_CCM.getId().equalsIgnoreCase(aid.getId())) {
            return AES_CCM_128;
        }
        if (NISTObjectIdentifiers.id_aes192_CCM.getId().equalsIgnoreCase(aid.getId())) {
            return AES_CCM_192;
        }
        return AES_CCM_256;
    }

    public static SdfAeadType convertSdfAeadType(String algorithm) {
        if (SdfAeadType.AES_CCM_128.name.equalsIgnoreCase(algorithm)) {
            return AES_CCM_128;
        }
        if (SdfAeadType.AES_CCM_192.name.equalsIgnoreCase(algorithm)) {
            return AES_CCM_192;
        }
        return AES_CCM_256;
    }

    public static boolean checkSupportType(ASN1ObjectIdentifier aid) {
        return AES_CCM_128.getAid().getId().equalsIgnoreCase(aid.getId()) || AES_CCM_192.getAid().getId().equalsIgnoreCase(aid.getId()) || AES_CCM_256.getAid().getId().equalsIgnoreCase(aid.getId());
    }
}

