/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdfECBaseSigner
extends SdfSigner {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExtendedDigest digest;
    protected SdfECKeyParameters ecKey;
    protected String signAlgName;

    public SdfECBaseSigner() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfECBaseSigner(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfECBaseSigner(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public SdfECBaseSigner(SdfSDK sdfSDK, String signAlgName) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.signAlgName = signAlgName;
        this.sdfSDK.init();
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        byte[] userID;
        if (param instanceof ParametersWithID) {
            this.ecKey = (SdfECKeyParameters)((ParametersWithID)param).getParameters();
            userID = ((ParametersWithID)param).getID();
        } else {
            this.ecKey = (SdfECKeyParameters)param;
            userID = Hex.decode("31323334353637383132333435363738");
        }
        try {
            if (null == this.signAlgName || this.signAlgName.toUpperCase().contains("SM3")) {
                SdfECCPublicKey sdfECCPublicKey = forSigning ? this.sdfSDK.exportSignPublicKeyEcc(this.ecKey.getEcIndex()) : this.ecKey.getSDFECCPublicKey();
                this.initDigest(userID, sdfECCPublicKey);
            } else {
                this.initDigest(this.signAlgName);
            }
        }
        catch (SdfSDKException e) {
            this.logger.error("init", e);
        }
    }

    public abstract void initDigest(byte[] var1, SdfECCPublicKey var2) throws SdfSDKException;

    public abstract void initDigest(String var1) throws SdfSDKException;

    @Override
    public void update(byte b) {
        byte[] bytes = new byte[]{b};
        this.update(bytes, 0, bytes.length);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] out = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(out, 0);
        out = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(out, 32);
        try {
            SdfECCSignature sdfECCSignature = this.sdfSDK.internalSignECC(this.ecKey.getEcIndex(), this.ecKey.getPassword(), out);
            return this.derEncode(sdfECCSignature.getR(), sdfECCSignature.getS());
        }
        catch (SdfSDKException | IOException e) {
            GMSSLByteArrayUtils.printHexBinary(this.logger, "signature  digest", out);
            this.logger.error("generateSignature error index={} password={}", this.ecKey.getEcIndex(), this.ecKey.getPassword(), e);
            return new byte[0];
        }
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        byte[] out = new byte[this.digest.getDigestSize()];
        try {
            this.digest.doFinal(out, 0);
            out = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(out, 32);
            BigInteger[] bigIntegers = this.derDecode(signature);
            byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInHead(bigIntegers[0].toByteArray());
            byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInHead(bigIntegers[1].toByteArray());
            SdfECCSignature sdfECCSignature = new SdfECCSignature(r, s);
            if (null == this.signAlgName) {
                this.sdfSDK.externalVerifyECC(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature);
            } else {
                this.sdfSDK.externalVerifyECC(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature, this.signAlgName);
            }
            return true;
        }
        catch (SdfSDKException | IOException e) {
            if (signature != null) {
                GMSSLByteArrayUtils.printHexBinary(this.logger, "verifySignature sm3 digest", out, true);
                GMSSLByteArrayUtils.printHexBinary(this.logger, "verifySignature x", this.ecKey.getSDFECCPublicKey().getX(), true);
                GMSSLByteArrayUtils.printHexBinary(this.logger, "verifySignature y", this.ecKey.getSDFECCPublicKey().getY(), true);
                GMSSLByteArrayUtils.printHexBinary(this.logger, "verifySignature signature", signature, true);
            }
            this.logger.error("verifySignature", e);
            return false;
        }
    }

    @Override
    public void reset() {
    }

    protected BigInteger[] derDecode(byte[] encoding) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = this.derEncode(r, s = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual(expectedEncoding, encoding)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }

    protected byte[] derEncode(byte[] r, byte[] s) throws IOException {
        return this.derEncode(BigIntegers.fromUnsignedByteArray(r), BigIntegers.fromUnsignedByteArray(s));
    }

    protected byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(r));
        v.add(new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }
}

