/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfECKeyParameters
extends AsymmetricKeyParameter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ECPublicKey publicKey;
    private SdfPrivateKey privateKey;

    public SdfECKeyParameters(ECPublicKey publicKey) {
        super(false);
        this.publicKey = publicKey;
    }

    public SdfECKeyParameters(SdfPrivateKey privateKey) {
        super(true);
        this.privateKey = privateKey;
    }

    public ECPoint getQ() {
        return this.publicKey.getW();
    }

    public SdfECCPublicKey getSDFECCPublicKey() {
        if (this.publicKey != null) {
            return SdfECCPublicKey.getInstance(this.publicKey);
        }
        return null;
    }

    public int getEcIndex() {
        return this.privateKey.getIndex();
    }

    public byte[] getPassword() {
        return this.privateKey.getPassword();
    }
}

