/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfBaseDigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSHADigest
extends SdfBaseDigest {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int SHA1_DIGEST_LENGTH = 20;
    private static final int SHA256_DIGEST_LENGTH = 32;
    private static final int BYTE_LENGTH = 64;
    private SdfAlgIdHash sdfAlgIdHash;

    public SdfSHADigest(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfAlgIdHash);
    }

    public SdfSHADigest(SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfAlgIdHash);
    }

    public SdfSHADigest(SdfSDK sdfSDK, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        super(sdfSDK);
        this.sdfAlgIdHash = sdfAlgIdHash;
    }

    public SdfSHADigest(SdfSHADigest t) throws SdfSDKException {
        this.copyIn(t);
    }

    @Override
    protected void init() throws SdfSDKException {
        this.sdfSDK.hashInit(this.sdfAlgIdHash);
    }

    @Override
    public String getAlgorithmName() {
        return this.sdfAlgIdHash.getName();
    }

    @Override
    public int getDigestSize() {
        return this.sdfAlgIdHash.getId() == SdfAlgIdHash.SGD_SHA1.getId() ? 20 : 32;
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    @Override
    public Memoable copy() {
        try {
            return new SdfSHADigest(this);
        }
        catch (SdfSDKException e) {
            this.logger.error("Memoable copy", e);
            return null;
        }
    }

    @Override
    public void reset(Memoable other) {
        SdfSHADigest d = (SdfSHADigest)other;
        try {
            this.copyIn(d);
            d.releaseConnection();
        }
        catch (SdfSDKException e) {
            this.logger.error("reset copy in error", e);
        }
    }
}

