/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.math.BigInteger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class SdfSM2SignerSM3
extends SdfECBaseSigner {
    public SdfSM2SignerSM3() throws SdfSDKException {
        super(SdfCryptoType.YUNHSM);
    }

    public SdfSM2SignerSM3(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK());
    }

    public SdfSM2SignerSM3(SdfSDK sdfSDK) throws SdfSDKException {
        super(sdfSDK);
    }

    public SdfSM2SignerSM3(SdfSDK sdfSDK, String signAlgName) throws SdfSDKException {
        super(sdfSDK, signAlgName);
    }

    public SdfSM2SignerSM3(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
    }

    @Override
    public void initDigest(byte[] userID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        this.digest = new SM3Digest();
        byte[] z = this.getZ(userID, sdfECCPublicKey.getX(), sdfECCPublicKey.getY());
        this.digest.update(z, 0, z.length);
    }

    @Override
    public void initDigest(String signAlgName) throws SdfSDKException {
        if (signAlgName.toUpperCase().contains("SHA256")) {
            this.digest = new SHA256Digest();
        } else if (signAlgName.toUpperCase().contains("SHA1")) {
            this.digest = new SHA1Digest();
        } else {
            throw new SdfSDKException("un support signAlgName is " + signAlgName);
        }
    }

    private byte[] getZ(byte[] userID, byte[] x, byte[] y) {
        this.digest.reset();
        this.addUserID(this.digest, userID);
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(GMSSLX509Utils.ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint G = ecParameterSpec.getG();
        this.addFieldElement(this.digest, curve.getA().toBigInteger());
        this.addFieldElement(this.digest, curve.getB().toBigInteger());
        this.addFieldElement(this.digest, G.getAffineXCoord().toBigInteger());
        this.addFieldElement(this.digest, G.getAffineYCoord().toBigInteger());
        this.addFieldElement(this.digest, BigIntegers.fromUnsignedByteArray(x));
        this.addFieldElement(this.digest, BigIntegers.fromUnsignedByteArray(y));
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        return result;
    }

    private void addUserID(Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(Digest digest, BigInteger p) {
        byte[] in = GMSSLByteArrayUtils.asUnsignedByteArray32(p);
        digest.update(in, 0, in.length);
    }
}

