/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfSymmetricKeyHandle;
import java.io.IOException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSymmetricKey {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfSDK sdfSDK;

    public SdfSymmetricKey() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfSymmetricKey(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSymmetricKey(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        sdfSDK.init();
    }

    public byte[] generateKeyWithEpkEcc(ECPublicKey publicKey) throws SdfSDKException {
        byte[] out;
        SdfECCPublicKey sdfECCPublicKey = SdfECCPublicKey.getInstance(publicKey);
        SdfECCCipher eccCipher = this.sdfSDK.generateKeyWithEpkEcc(sdfECCPublicKey);
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(eccCipher.getX(), eccCipher.getY(), eccCipher.getM(), eccCipher.getC());
        try {
            out = asn1SM2Cipher.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new SdfSDKException("asn1 sm2 cipher encode error", e);
        }
        return out;
    }

    public long[] generateKeyWithEpkEccHandle(ECPublicKey publicKey) throws SdfSDKException {
        SdfECCPublicKey sdfECCPublicKey = SdfECCPublicKey.getInstance(publicKey);
        return this.sdfSDK.generateKeyWithEpkEccHandle(sdfECCPublicKey);
    }

    public KeyHandle generateKeyWithEpkEccKeyHandle(ECPublicKey publicKey) throws SdfSDKException {
        byte[] out;
        SdfECCPublicKey sdfECCPublicKey = SdfECCPublicKey.getInstance(publicKey);
        SdfSymmetricKeyHandle keyHandle = this.sdfSDK.generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        SdfECCCipher eccCipher = keyHandle.getCipherKey();
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(eccCipher.getX(), eccCipher.getY(), eccCipher.getM(), eccCipher.getC());
        try {
            out = asn1SM2Cipher.toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new SdfSDKException("asn1 sm2 cipher encode error", e);
        }
        return new KeyHandle(out, keyHandle.getHandle());
    }

    public long[] importKeyWithIskEcc(int index, String password, byte[] cipher) throws SdfSDKException {
        ASN1SM2Cipher sm2CipherASN1 = ASN1SM2Cipher.getInstance(cipher);
        assert (sm2CipherASN1 != null);
        SdfECCCipher sdfECCCipher = new SdfECCCipher(sm2CipherASN1.getxCoordinate().toByteArray(), sm2CipherASN1.getyCoordinate().toByteArray(), sm2CipherASN1.getHash(), sm2CipherASN1.getCipherText().length, sm2CipherASN1.getCipherText());
        long[] handle = this.sdfSDK.importKeyWithIskEcc(index, password.getBytes(), sdfECCCipher);
        return handle;
    }

    public long[] importKeyWithIskEcc(SdfPrivateKey sdfPrivateKey, byte[] cipher) throws SdfSDKException {
        return this.importKeyWithIskEcc(sdfPrivateKey.getIndex(), sdfPrivateKey.getStringPassword(), cipher);
    }

    public byte[] generateKeyWithEpkRsa(RSAPublicKey publicKey) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = SdfRSAPublicKey.getInstance(publicKey);
        return this.sdfSDK.generateKeyWithEpkRsa(sdfRSAPublicKey);
    }

    public long[] generateKeyWithEpkRsaHandle(RSAPublicKey publicKey) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = SdfRSAPublicKey.getInstance(publicKey);
        return this.sdfSDK.generateKeyWithEpkRsaHandle(sdfRSAPublicKey);
    }

    public KeyHandle generateKeyWithEpkRsaKeyHandle(RSAPublicKey publicKey) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = SdfRSAPublicKey.getInstance(publicKey);
        SdfSymmetricKeyHandle keyHandle = this.sdfSDK.generateKeyWithEpkRsaKeyHandle(sdfRSAPublicKey);
        return new KeyHandle(keyHandle.getRsaCipherKey(), keyHandle.getHandle());
    }

    public long[] importKeyWithIskRsa(int index, String password, byte[] cipher) throws SdfSDKException {
        return this.sdfSDK.importKeyWithIskRsa(index, password.getBytes(), cipher);
    }

    public long[] importKeyWithIskRsa(SdfPrivateKey sdfPrivateKey, byte[] cipher) throws SdfSDKException {
        return this.importKeyWithIskRsa(sdfPrivateKey.getIndex(), sdfPrivateKey.getStringPassword(), cipher);
    }

    public long[] importKeyWithKek(SdfAlgIdSymmetric sdfAlgIdSymmetric, int keyIndex, byte[] cipher) throws SdfSDKException {
        return this.sdfSDK.importKeyWithKek(sdfAlgIdSymmetric, keyIndex, cipher);
    }

    public long[] importKey(byte[] key) throws SdfSDKException {
        return this.sdfSDK.importKey(key);
    }

    public void destroyKey(long[] handle) throws SdfSDKException {
        this.sdfSDK.destroyKey(handle);
    }

    public void release() throws SdfSDKException {
        this.sdfSDK.release();
    }

    public class KeyHandle {
        private byte[] cipherKey;
        private long[] handle;

        public KeyHandle(byte[] cipherKey, long[] handle) {
            this.cipherKey = cipherKey;
            this.handle = handle;
        }

        public byte[] getCipherKey() {
            return this.cipherKey;
        }

        public long[] getHandle() {
            return this.handle;
        }
    }
}

