/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCCipherUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;

public class GMSSLAES128ECBEncryptUtils {
    public static byte[] encryptWithKek(byte[] kek, int kekIndex, SdfAlgIdSymmetric keyEncryptKeyType, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptWithKekBySdf(true, SdfCryptoType.YUNHSM, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        throw new IllegalArgumentException("un support kek encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] decryptWithKek(byte[] kek, int kekIndex, SdfAlgIdSymmetric keyEncryptKeyType, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptWithKekBySdf(false, SdfCryptoType.YUNHSM, paddingType, keyEncryptKeyType, kekIndex, kek, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        throw new IllegalArgumentException("un support kek encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] encrypt(byte[] key, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(true, SdfCryptoType.YUNHSM, paddingType, key, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        switch (paddingType) {
            case NoPadding: {
                return GMSSLBCCipherUtils.symmetricECBEncrypt("AES/ECB/NoPadding", key, data);
            }
            case PKCS5Padding: {
                return GMSSLBCCipherUtils.symmetricECBEncrypt("AES/ECB/PKCS5Padding", key, data);
            }
            case PKCS7Padding: {
                return GMSSLBCCipherUtils.symmetricECBEncrypt("AES/ECB/PKCS7Padding", key, data);
            }
        }
        throw new Exception("un support the padding type " + (Object)((Object)paddingType));
    }

    public static byte[] decrypt(byte[] key, byte[] data, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(false, SdfCryptoType.YUNHSM, paddingType, key, SdfAlgIdSymmetric.SGD_AES_ECB, data);
            }
        }
        switch (paddingType) {
            case NoPadding: {
                return GMSSLBCCipherUtils.symmetricECBDecrypt("AES/ECB/NoPadding", key, data);
            }
            case PKCS5Padding: {
                return GMSSLBCCipherUtils.symmetricECBDecrypt("AES/ECB/PKCS5Padding", key, data);
            }
            case PKCS7Padding: {
                return GMSSLBCCipherUtils.symmetricECBDecrypt("AES/ECB/PKCS7Padding", key, data);
            }
        }
        throw new Exception("un support the padding type " + (Object)((Object)paddingType));
    }
}

