/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.operator.utils.GMSSLPKCS1Encodeing;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;

public class GMSSLRSAEncryptUtils {
    public static byte[] encrypt(PublicKey publicKey, byte[] data) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            default: 
        }
        return GMSSLRSAUtils.encryptData(publicKey, data);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] cipher) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            default: 
        }
        return GMSSLRSAUtils.decryptData(privateKey, cipher);
    }

    public static byte[] encryptWithPKCS1(PublicKey publicKey, byte[] data) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case SANC_HSM: {
                int bitLength = ((BCRSAPublicKey)publicKey).getModulus().bitLength();
                byte[] encodeData = GMSSLPKCS1Encodeing.encodeBlock(data, 0, data.length, bitLength);
                IRSArefPublicKey arefPublicKey = GMSSLSancConverUtils.converRSARefPublicKey(publicKey);
                return GMSSLSancConnectionUtils.getCryptConnection().rsaPublicKeyOperation(arefPublicKey, encodeData);
            }
        }
        return GMSSLRSAUtils.encryptDataPKCS1Padding(publicKey, data);
    }

    public static byte[] decryptWithPKCS1(PrivateKey privateKey, byte[] cipher) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                SdfPrivateKey sancPrivate = (SdfPrivateKey)privateKey;
                byte[] decrypt = cryptConnection.rsaPrivateKeyOperation(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType(), cipher);
                IRSArefPublicKey rsaPublicKey = cryptConnection.getRSAPublicKey(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType());
                return GMSSLPKCS1Encodeing.decodeBlock(decrypt, rsaPublicKey.getBits());
            }
        }
        return GMSSLRSAUtils.decryptDataPKCS1Padding(privateKey, cipher);
    }

    public static String encryptDataByBC(PublicKey publicKey, String data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode(data);
        byte[] cipher = GMSSLRSAUtils.encryptData(publicKey, plain);
        return GMSSLByteArrayUtils.base64Encode(cipher);
    }

    public static String decryptDataByBC(PrivateKey privateKey, String data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode(data);
        byte[] plain = GMSSLRSAUtils.decryptData(privateKey, cipher);
        return GMSSLByteArrayUtils.base64Encode(plain);
    }

    public static byte[] encryptDataByBC(PublicKey publicKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.encryptData(publicKey, data);
    }

    public static byte[] decryptDataByBC(PrivateKey privateKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.decryptData(privateKey, data);
    }

    public static String encryptDataPKCS1ByBC(PublicKey publicKey, String data) throws InvalidCipherTextException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode(data);
        byte[] cipher = GMSSLRSAUtils.encryptDataPKCS1Padding(publicKey, plain);
        return GMSSLByteArrayUtils.base64Encode(cipher);
    }

    public static String decryptDataPKCS1ByBC(PrivateKey privateKey, String data) throws InvalidCipherTextException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode(data);
        byte[] plain = GMSSLRSAUtils.decryptDataPKCS1Padding(privateKey, cipher);
        return GMSSLByteArrayUtils.base64Encode(plain);
    }

    public static byte[] encryptDataPKCS1ByBC(PublicKey publicKey, byte[] data) throws InvalidCipherTextException {
        return GMSSLRSAUtils.encryptDataPKCS1Padding(publicKey, data);
    }

    public static byte[] decryptDataPKCS1ByBC(PrivateKey privateKey, byte[] data) throws InvalidCipherTextException {
        return GMSSLRSAUtils.decryptDataPKCS1Padding(privateKey, data);
    }
}

