/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKey;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRsaKeyPair;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;

public class GMSSLRSAKeyUtils {
    public static final String RSA_ALGORITHM_NAME = "RSA";
    public static final int RSA_KEY_SIZE_1024 = 1024;
    public static final int RSA_KEY_SIZE_2048 = 2048;
    public static final int RSA_KEY_SIZE_3072 = 3072;
    public static final int RSA_KEY_SIZE_4096 = 4096;

    public static KeyPair generateRSAKeyPair(int keySize) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLRSAKeyUtils.generateKeyPairBySdf(SdfCryptoType.PCIE, keySize);
            }
            case XDJA_HSM: {
                return GMSSLRSAKeyUtils.generateKeyPairBySdf(SdfCryptoType.YUNHSM, keySize);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                RSArefKeyPair rsArefKeyPair = cryptConnection.generateRSAKeyPair(keySize);
                return new KeyPair(GMSSLSancConverUtils.converRSAPublicKey(rsArefKeyPair.getPublicKey()), GMSSLSancConverUtils.converRSAPrivateKey(rsArefKeyPair.getPrivateKey()));
            }
        }
        return GMSSLRSAKeyUtils.generateKeyPairByBC(keySize);
    }

    public static SdfPrivateKey genSdfPrivateKey(int index, String password) {
        return new SdfPrivateKey(index, password);
    }

    public static boolean getPrivateKeyAccessRightFromHardware(int index, String password) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
            }
            case PCI_E: {
                return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
            }
        }
        throw new Exception("the method un support the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static PublicKey getPublicKeyFromHardware(int index, boolean isEncryptKey) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                if (isEncryptKey) {
                    return GMSSLRSAKeyUtils.getEncryptPublicKeyByPcie(index);
                }
                return GMSSLRSAKeyUtils.getSignPublicKeyByPcie(index);
            }
            case XDJA_HSM: {
                if (isEncryptKey) {
                    return GMSSLRSAKeyUtils.getEncryptPublicKeyByYunhsm(index);
                }
                return GMSSLRSAKeyUtils.getSignPublicKeyByYunhsm(index);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                IRSArefPublicKey rsaPublicKey = isEncryptKey ? cryptConnection.getRSAPublicKey(index, GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType()) : cryptConnection.getRSAPublicKey(index, GMSSLSancKeyTypeEnum.SIGN.getKeyType());
                return GMSSLSancConverUtils.converRSAPublicKey(rsaPublicKey);
            }
        }
        throw new Exception("un support the method with the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static KeyPair generateKeyPairByBC(int keySize) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(RSA_ALGORITHM_NAME, "BC");
        kpGen.initialize(keySize);
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateKeyPairByYunHsm(int keySize) throws Exception {
        return GMSSLRSAKeyUtils.generateKeyPairBySdf(SdfCryptoType.YUNHSM, keySize);
    }

    public static KeyPair generateKeyPairBySdf(SdfCryptoType sdfCryptoType, int keySize) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSAKeyUtils.generateRSAKeyPair(keySize);
        }
        SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
        sdfSDK.init();
        SdfRsaKeyPair sdfRsaKeyPair = sdfSDK.generateKeyPairRsa(keySize);
        sdfSDK.release();
        SdfRSAPrivateKey rsaPrivateKey = sdfRsaKeyPair.getSdfRSAPrivateKey();
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getM()), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getE()), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getD()), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getPrime()[0]), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getPrime()[1]), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getPexp()[0]), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getPexp()[1]), BigIntegers.fromUnsignedByteArray(rsaPrivateKey.getCoef()));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM_NAME, "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(spec);
        SdfRSAPublicKey rsaPublicKey = sdfRsaKeyPair.getSdfRSAPublicKey();
        RSAPublicKeySpec spec1 = new RSAPublicKeySpec(BigIntegers.fromUnsignedByteArray(rsaPublicKey.getM()), BigIntegers.fromUnsignedByteArray(rsaPublicKey.getE()));
        PublicKey pk = keyFactory.generatePublic(spec1);
        return new KeyPair(pk, privateKey);
    }

    public static PublicKey getSignPublicKeyByYunhsm(int index) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, false);
        }
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfRSAKey.exportSignPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByPcie(int index) throws Exception {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfRSAKey.exportSignPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByYunhsm(int index) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, true);
        }
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfRSAKey.exportEncryptPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByPcie(int index) throws Exception {
        SdfRSAKey sdfRSAKey = new SdfRSAKey(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfRSAKey.exportEncryptPublicKey(index);
        sdfRSAKey.release();
        return publicKey;
    }

    public static boolean getPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromPCIE(int index, String password) {
        return GMSSLRSAKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromSdf(SdfCryptoType sdfCryptoType, int index, String password) {
        try {
            SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
            sdfSDK.init();
            boolean result = sdfSDK.checkPrivateKeyAccessRight(index, password.getBytes());
            sdfSDK.release();
            return result;
        }
        catch (SdfSDKException e) {
            return false;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

