/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.crypto_hsm.SDSCryptoFactory;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import java.io.File;

public class GMSSLSancConnectionUtils {
    private static SDSCryptoFactory sdsCryptoFactory = new SDSCryptoFactory();

    public static void init() throws CryptoException {
        String path = GMSSLSancHsmUtils.getConfPath(false) + File.separator + "swsds.ini";
        GMSSLSancConnectionUtils.init(path);
    }

    public static void init(String configPath) throws CryptoException {
        sdsCryptoFactory.getInstance(GMSSLFileUtils.getResourceAsPath(configPath));
    }

    public static ISDSCrypto getCryptConnection() throws CryptoException {
        return sdsCryptoFactory.getInstance();
    }

    public static void releaseConnection() {
        SDSCryptoFactory.releaseInstance();
    }

    public static void reInit(String configPath) throws Exception {
        GMSSLSancConnectionUtils.releaseConnection();
        GMSSLSancConnectionUtils.init(configPath);
    }
}

