/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class GMSSLIniFileUtils {
    public static boolean createProfile(String filePath, String ip, int port, String loginPassword, String clientKeyStorePath, String trustKeyStorePath, String clientKeyStorePass, String trustKeyStorePass) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineFeed = "\n";
        sb.append("#SWXA\u5bc6\u7801\u8bbe\u5907\u63a5\u53e3\u914d\u7f6e\u6587\u4ef6").append(lineFeed);
        sb.append("[Device]").append(lineFeed);
        sb.append("device=CMD").append(lineFeed);
        sb.append("[ErrorLog]").append(lineFeed);
        sb.append("level=3").append(lineFeed);
        sb.append("logfile=swsds.log").append(lineFeed);
        sb.append("maxsize=100").append(lineFeed);
        sb.append("count=3").append(lineFeed);
        sb.append("[HSM1]").append(lineFeed);
        sb.append("ip=").append(ip).append(lineFeed);
        sb.append("port=").append(port).append(lineFeed);
        sb.append("passwd=").append(loginPassword).append(lineFeed);
        sb.append("[Timeout]").append(lineFeed);
        sb.append("connect=20").append(lineFeed);
        sb.append("service=20").append(lineFeed);
        sb.append("[ConnectionPool]").append(lineFeed);
        sb.append("poolsize=50").append(lineFeed);
        GMSSLFileUtils.writeFile(filePath, "swsds.ini", sb.toString().getBytes());
        return true;
    }

    public static boolean setProfileValue(String writePath, String section, String key, String value) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(writePath + File.separator + "swsds.ini"));
        StringBuilder fileContent = new StringBuilder();
        boolean isChange = false;
        try {
            String allLine;
            block5: while ((allLine = bufferedReader.readLine()) != null) {
                String strLine;
                fileContent.append(allLine + "\n");
                if (!(allLine = allLine.trim()).startsWith("[") || !allLine.equalsIgnoreCase("[" + section + "]")) continue;
                while ((strLine = bufferedReader.readLine()) != null) {
                    if (strLine.startsWith("[")) {
                        fileContent.append(strLine + "\n");
                        continue block5;
                    }
                    if (!strLine.trim().startsWith(key)) continue;
                    String changeText = strLine.substring(0, strLine.indexOf(61) + 1);
                    changeText = changeText + value;
                    fileContent.append(changeText + "\n");
                    isChange = true;
                }
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            bufferedReader.close();
        }
        System.out.println(fileContent);
        if (isChange) {
            GMSSLX509Utils.writeFile(writePath + File.separator, "swsds.ini", fileContent.toString().getBytes());
            return true;
        }
        return false;
    }

    public static String getProfileValue(String filePath, String item, String key) {
        String str = null;
        item = "[" + item + "]";
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            boolean findItem = false;
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("") || line.charAt(0) == '#') continue;
                String tmpLine = line.toLowerCase();
                if (tmpLine.contains(item.toLowerCase())) {
                    findItem = true;
                    continue;
                }
                if (findItem && tmpLine.contains(key.toLowerCase())) {
                    str = line.substring(line.indexOf("=") + 1);
                    str = str.trim();
                    break;
                }
                if (!findItem || !tmpLine.contains("[")) continue;
                break;
            }
            br.close();
            return str;
        }
        catch (Exception e) {
            return null;
        }
    }
}

