/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.DeviceInfo;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLIniFileUtils;
import com.xdja.pki.gmssl.x509.utils.bean.SancHsmInfoEntry;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLSancHsmUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLSancHsmUtils.class);
    public static final String confName = "swsds.ini";

    public static YunHsmExceptionEnum testConnect() {
        try {
            ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
            DeviceInfo deviceInfo = cryptConnection.getDeviceInfo();
            logger.info(deviceInfo.toString());
            return YunHsmExceptionEnum.NORMAL;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static YunHsmExceptionEnum testConnect(String ip, int port, String loginPass) {
        return GMSSLSancHsmUtils.testConnect(ip, port, loginPass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YunHsmExceptionEnum testConnect(String ip, int port, String loginPass, boolean isInit) {
        try {
            GMSSLSancConnectionUtils.releaseConnection();
            String confPath = GMSSLSancHsmUtils.getConfPath(true);
            GMSSLIniFileUtils.createProfile(confPath, ip, port, loginPass, null, null, null, null);
            GMSSLSancConnectionUtils.init(confPath + confName);
            DeviceInfo deviceInfo = GMSSLSancConnectionUtils.getCryptConnection().getDeviceInfo();
            GMSSLSancConnectionUtils.releaseConnection();
            logger.info(deviceInfo.toString());
            YunHsmExceptionEnum yunHsmExceptionEnum = YunHsmExceptionEnum.NORMAL;
            return yunHsmExceptionEnum;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5931\u8d25", e);
            YunHsmExceptionEnum yunHsmExceptionEnum = YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
            return yunHsmExceptionEnum;
        }
        finally {
            try {
                if (isInit) {
                    String confPath = GMSSLSancHsmUtils.getConfPath(false) + File.separator + confName;
                    File file = new File(confPath);
                    if (file.exists()) {
                        GMSSLSancConnectionUtils.init();
                        logger.info("\u91cd\u65b0\u4f7f\u7528\u539f\u6765\u5bc6\u7801\u673a\u914d\u7f6e\u8fde\u63a5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a");
                    } else {
                        logger.info("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6\u8def\u5f84");
                    }
                } else {
                    logger.info("\u7cfb\u7edf\u6682\u672a\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u8fde\u63a5\u5bc6\u7801\u673a");
                }
            }
            catch (Exception e) {
                logger.info("\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u4f7f\u7528\u539f\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25");
            }
        }
    }

    public static YunHsmExceptionEnum initConfigAndTestConnect(String ip, int port, String loginPass) {
        return GMSSLSancHsmUtils.initConfigAndTestConnect(ip, port, loginPass, true);
    }

    public static YunHsmExceptionEnum initConfigAndTestConnect(String ip, int port, String loginPass, boolean isInit) {
        try {
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect(ip, port, loginPass, isInit);
            if (yunHsmExceptionEnum != YunHsmExceptionEnum.NORMAL) {
                return yunHsmExceptionEnum;
            }
            GMSSLSancConnectionUtils.releaseConnection();
            String goalConfPath = GMSSLSancHsmUtils.getConfPath(false);
            GMSSLIniFileUtils.createProfile(goalConfPath, ip, port, loginPass, null, null, null, null);
            GMSSLPkiCryptoInit.getSancHsmInstance();
            DeviceInfo deviceInfo = GMSSLSancConnectionUtils.getCryptConnection().getDeviceInfo();
            logger.info(deviceInfo.toString());
            return YunHsmExceptionEnum.NORMAL;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5931\u8d25,", e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static SancHsmInfoEntry getSancDeviceInfo() {
        String confPath = GMSSLSancHsmUtils.getConfPath(false) + File.separator + confName;
        String ip = GMSSLIniFileUtils.getProfileValue(confPath, "HSM1", "ip");
        String port = GMSSLIniFileUtils.getProfileValue(confPath, "HSM1", "port");
        String loginPasswd = GMSSLIniFileUtils.getProfileValue(confPath, "HSM1", "passwd");
        SancHsmInfoEntry sancHsmInfoEntry = new SancHsmInfoEntry();
        sancHsmInfoEntry.setIp(ip);
        sancHsmInfoEntry.setPort(Integer.valueOf(port));
        sancHsmInfoEntry.setLoginPasswd(loginPasswd);
        return sancHsmInfoEntry;
    }

    public static String getConfPath(boolean isTest) {
        String tomcatPath = System.getProperty("catalina.home");
        if (null == tomcatPath || tomcatPath.contains("Temp")) {
            tomcatPath = "/home/xdja";
        }
        String path = isTest ? tomcatPath + "/conf/sancConfTest/" : tomcatPath + "/conf/sancConf/";
        return path;
    }
}

