/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.logger;

import com.xdja.logger.Level;
import com.xdja.logger.Logger;
import com.xdja.logger.LoggerAdapter;
import com.xdja.logger.logback.LogBackLoggerAdapter;
import com.xdja.logger.support.FailsafeLogger;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static volatile LoggerAdapter LOGGER_ADAPTER;
    private static final ConcurrentMap<String, FailsafeLogger> LOGGERS;

    private LoggerFactory() {
    }

    public static void setLoggerAdapter(LoggerAdapter loggerAdapter) {
        if (loggerAdapter != null) {
            LOGGER_ADAPTER = loggerAdapter;
            for (Map.Entry entry : LOGGERS.entrySet()) {
                ((FailsafeLogger)entry.getValue()).setLogger(LOGGER_ADAPTER.getLogger((String)entry.getKey()));
            }
        }
    }

    public static Logger getLogger(Class<?> key) {
        FailsafeLogger logger = (FailsafeLogger)LOGGERS.get(key.getName());
        if (logger == null) {
            LOGGERS.putIfAbsent(key.getName(), new FailsafeLogger(LOGGER_ADAPTER.getLogger(key)));
            logger = (FailsafeLogger)LOGGERS.get(key.getName());
        }
        return logger;
    }

    public static Logger getLogger(String key) {
        FailsafeLogger logger = (FailsafeLogger)LOGGERS.get(key);
        if (logger == null) {
            LOGGERS.putIfAbsent(key, new FailsafeLogger(LOGGER_ADAPTER.getLogger(key)));
            logger = (FailsafeLogger)LOGGERS.get(key);
        }
        return logger;
    }

    public static void setLevel(Level level) {
        LOGGER_ADAPTER.setLevel(level);
    }

    public static Level getLevel() {
        return LOGGER_ADAPTER.getLevel();
    }

    public static File getFile() {
        return LOGGER_ADAPTER.getFile();
    }

    static {
        LOGGERS = new ConcurrentHashMap<String, FailsafeLogger>();
        LoggerFactory.setLoggerAdapter(new LogBackLoggerAdapter());
    }
}

