/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.logger.logback;

import com.xdja.logger.Level;
import com.xdja.logger.Logger;
import com.xdja.logger.util.LevelUtil;

public class LogBackLogger
implements Logger {
    private final org.slf4j.Logger logger;
    private static final String DELIMITED = "|";

    public LogBackLogger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    private static String appenderMsg(String ... msgs) {
        if (msgs != null && msgs.length > 0) {
            StringBuilder result = new StringBuilder("");
            for (String msg : msgs) {
                result.append(msg).append(DELIMITED);
            }
            return result.substring(0, result.length() - 1);
        }
        return null;
    }

    public void trace(String ... msgs) {
        this.logger.trace(LogBackLogger.appenderMsg(msgs));
    }

    public void trace(Throwable e) {
        this.logger.trace(e.getMessage(), e);
    }

    public void trace(Throwable e, String ... msgs) {
        this.logger.trace(LogBackLogger.appenderMsg(msgs), e);
    }

    public void debug(String ... msgs) {
        this.logger.debug(LogBackLogger.appenderMsg(msgs));
    }

    public void debug(Throwable e) {
        this.logger.debug(e.getMessage(), e);
    }

    public void debug(Throwable e, String ... msgs) {
        this.logger.debug(LogBackLogger.appenderMsg(msgs), e);
    }

    public void info(String ... msgs) {
        this.logger.info(LogBackLogger.appenderMsg(msgs));
    }

    public void info(Throwable e) {
        this.logger.info(e.getMessage(), e);
    }

    public void info(Throwable e, String ... msgs) {
        this.logger.info(LogBackLogger.appenderMsg(msgs), e);
    }

    public void warn(String ... msgs) {
        this.logger.warn(LogBackLogger.appenderMsg(msgs));
    }

    public void warn(Throwable e) {
        this.logger.warn(e.getMessage(), e);
    }

    public void warn(Throwable e, String ... msgs) {
        this.logger.warn(LogBackLogger.appenderMsg(msgs), e);
    }

    public void error(String ... msg) {
        this.logger.error(LogBackLogger.appenderMsg(msg));
    }

    public void error(Throwable e) {
        this.logger.error(e.getMessage(), e);
    }

    public void error(Throwable e, String ... msgs) {
        this.logger.error(LogBackLogger.appenderMsg(msgs), e);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void setLevel(Level level) {
        ch.qos.logback.classic.Logger newLogger = (ch.qos.logback.classic.Logger)this.logger;
        newLogger.setLevel(LevelUtil.toLogBackLevel(level));
    }
}

