/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttCallback;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientState;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import com.xdja.org.eclipse.paho.client.mqttv3.logging.Logger;
import com.xdja.org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.Vector;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME = CommsCallback.class.getName();
    private static final Logger log = LoggerFactory.getLogger("com.xdja.org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackThread = new Thread((Runnable)this, threadName);
                this.callbackThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.running) {
                log.fine(CLASS_NAME, "stop", "700");
                this.running = false;
                if (!Thread.currentThread().equals(this.callbackThread)) {
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            log.fine(CLASS_NAME, "stop", "701");
                            this.workAvailable.notifyAll();
                        }
                        this.callbackThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.callbackThread = null;
            log.fine(CLASS_NAME, "stop", "703");
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        while (this.running) {
            Object token;
            try {
                try {
                    Object object = this.workAvailable;
                    synchronized (object) {
                        if (this.running && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            log.fine(CLASS_NAME, "run", "704");
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.running) {
                    token = null;
                    Vector vector = this.completeQueue;
                    synchronized (vector) {
                        if (!this.completeQueue.isEmpty()) {
                            token = (MqttToken)this.completeQueue.elementAt(0);
                            this.completeQueue.removeElementAt(0);
                        }
                    }
                    if (null != token) {
                        this.handleActionComplete((MqttToken)token);
                    }
                    MqttPublish message = null;
                    Vector vector2 = this.messageQueue;
                    synchronized (vector2) {
                        if (!this.messageQueue.isEmpty()) {
                            message = (MqttPublish)this.messageQueue.elementAt(0);
                            this.messageQueue.removeElementAt(0);
                        }
                    }
                    if (null != message) {
                        this.handleMessage(message);
                    }
                }
                if (!this.quiescing) continue;
                this.clientState.checkQuiesceLock();
            }
            catch (Throwable ex) {
                log.fine(CLASS_NAME, "run", "714", null, ex);
                this.running = false;
                LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection CommsCallback run");
                this.clientComms.shutdownConnection(null, new MqttException(ex));
            }
            finally {
                token = this.spaceAvailable;
                synchronized (token) {
                    log.fine(CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        String methodName = "handleActionComplete";
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            log.fine(CLASS_NAME, "handleActionComplete", "705", new Object[]{token.internalTok.getKey()});
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token.isComplete() && (token instanceof MqttDeliveryToken || token.getActionCallback() instanceof IMqttActionListener)) {
                token.internalTok.setNotified(true);
            }
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
        }
    }

    public void connectionLost(MqttException cause) {
        String methodName = "connectionLost";
        try {
            if (this.mqttCallback != null && cause != null) {
                log.fine(CLASS_NAME, "connectionLost", "708", new Object[]{cause});
                this.mqttCallback.connectionLost(cause);
            }
        }
        catch (Throwable t) {
            log.fine(CLASS_NAME, "connectionLost", "720", new Object[]{t});
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        String methodName = "fireActionEvent";
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onSuccess(token);
            } else {
                log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(MqttPublish sendMessage) {
        String methodName = "messageArrived";
        if (this.mqttCallback != null) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                while (this.running && !this.quiescing && this.messageQueue.size() >= 10) {
                    try {
                        log.fine(CLASS_NAME, "messageArrived", "709");
                        this.spaceAvailable.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.quiescing) {
                this.messageQueue.addElement(sendMessage);
                object = this.workAvailable;
                synchronized (object) {
                    log.fine(CLASS_NAME, "messageArrived", "710");
                    this.workAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        String methodName = "quiesce";
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            log.fine(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        String methodName = "handleMessage";
        if (this.mqttCallback != null) {
            String destName = publishMessage.getTopicName();
            log.fine(CLASS_NAME, "handleMessage", "713", new Object[]{new Integer(publishMessage.getMessageId()), destName});
            this.mqttCallback.messageArrived(destName, publishMessage.getMessage());
            if (publishMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token) {
        String methodName = "asyncOperationComplete";
        if (this.running) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                log.fine(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{token.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            log.fine(CLASS_NAME, "asyncOperationComplete", "719", null, ex);
            LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection asyncOperationComplete");
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }
}

