/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import android.os.Handler;
import android.os.HandlerThread;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.concurrent.LinkedBlockingQueue;

public class CommsSendToutHandler {
    private final String TAG = CommsSendToutHandler.class.getCanonicalName();
    private static final int TIMEOUT_PEROID = 3000;
    private final LinkedBlockingQueue<MonitNode> sendNodesQueue = new LinkedBlockingQueue();
    private CommsTokenStore tokenStore = null;
    private ClientComms clientComms = null;
    private HandlerThread checkTimeOutThread = null;
    private Handler checkTimeOutHandler = null;

    public CommsSendToutHandler(CommsTokenStore tokenStore, ClientComms clientComms) {
        this.tokenStore = tokenStore;
        this.clientComms = clientComms;
        this.checkTimeOutThread = new HandlerThread("checkPingTimeOutThread");
        this.checkTimeOutThread.start();
        this.checkTimeOutHandler = new Handler(this.checkTimeOutThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSendMonitNode(MqttWireMessage message) {
        MonitNode node = new MonitNode(message);
        LinkedBlockingQueue<MonitNode> linkedBlockingQueue = this.sendNodesQueue;
        synchronized (linkedBlockingQueue) {
            LogHelper.getHelper(this.TAG).d("addSendMonitNode : " + message.getKey());
            this.sendNodesQueue.offer(node);
        }
        if (this.sendNodesQueue.size() == 1) {
            this.checkTimeOutHandler.postDelayed((Runnable)new checkNode(), (long)node.processTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshQueue() {
        LinkedBlockingQueue<MonitNode> linkedBlockingQueue = this.sendNodesQueue;
        synchronized (linkedBlockingQueue) {
            LogHelper.getHelper(this.TAG).d("send out check refreshQueue size:" + this.sendNodesQueue.size());
            if (this.sendNodesQueue.size() > 0) {
                MonitNode[] nodes = new MonitNode[this.sendNodesQueue.size()];
                nodes = this.sendNodesQueue.toArray(nodes);
                long nowT = System.currentTimeMillis();
                for (MonitNode node : this.sendNodesQueue) {
                    node.processTime = (int)(3000L - (nowT - node.createTime));
                    if (node.processTime >= 0) continue;
                    node.processTime = 0;
                }
                this.checkTimeOutHandler.postDelayed((Runnable)new checkNode(), (long)nodes[0].processTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearQueue() {
        LinkedBlockingQueue<MonitNode> linkedBlockingQueue = this.sendNodesQueue;
        synchronized (linkedBlockingQueue) {
            LogHelper.getHelper(this.TAG).d("send out check clearQueue size:" + this.sendNodesQueue.size());
            if (this.sendNodesQueue.size() > 0) {
                this.sendNodesQueue.clear();
            }
        }
    }

    class MonitNode {
        MqttWireMessage message;
        long createTime;
        int processTime;

        public MonitNode(MqttWireMessage message) {
            this.message = message;
            this.createTime = System.currentTimeMillis();
            this.processTime = 3000;
        }
    }

    class checkNode
    implements Runnable {
        checkNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MonitNode node = null;
            LinkedBlockingQueue linkedBlockingQueue = CommsSendToutHandler.this.sendNodesQueue;
            synchronized (linkedBlockingQueue) {
                LogHelper.getHelper(CommsSendToutHandler.this.TAG).d("poll monitnode");
                node = (MonitNode)CommsSendToutHandler.this.sendNodesQueue.poll();
            }
            if (null != node) {
                LogHelper.getHelper(CommsSendToutHandler.this.TAG).d("process this polled node:" + node.message.getKey());
                LogHelper.getHelper(CommsSendToutHandler.this.TAG).d("begin process: : " + System.currentTimeMillis());
                MqttToken token = CommsSendToutHandler.this.tokenStore.getToken(node.message);
                if (null != token) {
                    MqttException ex = ExceptionHelper.createMqttException(32000);
                    token.internalTok.setException(ex);
                    IMqttActionListener asyncCB = token.getActionCallback();
                    CommsSendToutHandler.this.clientComms.shutdownConnection(token, ex);
                    if (asyncCB != null) {
                        LogHelper.getHelper(CommsSendToutHandler.this.TAG).d("send out package time out\uff0c need release wacklock");
                        asyncCB.onFailure(token, ex);
                    }
                }
                CommsSendToutHandler.this.refreshQueue();
            }
        }
    }
}

