/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientState;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsSendToutHandler;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import com.xdja.org.eclipse.paho.client.mqttv3.logging.Logger;
import com.xdja.org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import com.xdja.pushsdk.utils.LogHelper;
import java.io.IOException;
import java.io.OutputStream;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private static final Logger log = LoggerFactory.getLogger("com.xdja.org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Thread sendThread = null;
    private CommsSendToutHandler timeOutHandler = null;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out, CommsSendToutHandler commsSendToutHandler) {
        this.out = new MqttOutputStream(clientState, out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        log.setResourceName(clientComms.getClient().getClientId());
        this.timeOutHandler = commsSendToutHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.sendThread = new Thread((Runnable)this, threadName);
                this.sendThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            log.fine(CLASS_NAME, "stop", "800");
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.sendThread)) {
                    try {
                        this.clientState.notifyQueueLock();
                        this.sendThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.sendThread = null;
            log.fine(CLASS_NAME, "stop", "801");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        MqttWireMessage message = null;
        while (this.running && this.out != null) {
            try {
                message = this.clientState.get();
                if (message != null) {
                    log.fine(CLASS_NAME, "run", "802", new Object[]{message.getKey(), message});
                    if (message instanceof MqttPingReq || message instanceof MqttConnect) {
                        this.timeOutHandler.addSendMonitNode(message);
                    }
                    if (message instanceof MqttAck) {
                        this.out.write(message);
                        this.out.flush();
                        continue;
                    }
                    MqttToken token = this.tokenStore.getToken(message);
                    if (token == null) continue;
                    MqttToken mqttToken = token;
                    synchronized (mqttToken) {
                        block12: {
                            this.out.write(message);
                            try {
                                LogHelper.getHelper("gbc").d("before flush: " + System.currentTimeMillis());
                                this.out.flush();
                            }
                            catch (IOException ex) {
                                if (message instanceof MqttDisconnect) break block12;
                                LogHelper.getHelper("gbc").d("flush has exception: " + System.currentTimeMillis());
                                throw ex;
                            }
                        }
                        LogHelper.getHelper("gbc").d("end flush: " + System.currentTimeMillis());
                        this.clientState.notifySent(message);
                        continue;
                    }
                }
                log.fine(CLASS_NAME, "run", "803");
                this.running = false;
            }
            catch (MqttException me) {
                this.handleRunException(message, me);
            }
            catch (Exception ex) {
                this.handleRunException(message, ex);
            }
        }
        log.fine(CLASS_NAME, "run", "805");
    }

    private void handleRunException(MqttWireMessage message, Exception ex) {
        String methodName = "handleRunException";
        log.fine(CLASS_NAME, "handleRunException", "804", null, ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.running = false;
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection CommsSender handleRunException");
        this.clientComms.shutdownConnection(null, mex);
    }
}

