/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.pushsdk.BuildConfig;
import com.xdja.pushsdk.IObtainMsgCallBack;
import com.xdja.pushsdk.npc.npcs.util.NPCManager;
import com.xdja.pushsdk.task.ProcessNotifyManager;
import com.xdja.pushsdk.utils.ConfigurationUtils;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.SharedPreUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PushClient {
    public static final String VERSION_CODE = "v1.2.20_S";

    public static int init(Context context, String clientId) {
        return PushClient.init(context, clientId, null, null, null);
    }

    public static int init(Context context, String clientId, String webApiIp, String webApiPort, String type) {
        LogHelper.getHelper().i("XdjaPushSdk_Version::v1.2.20_S");
        LogHelper.getHelper().i("XdjaPushSdk_BuildConfig.DEBUG::" + BuildConfig.DEBUG);
        boolean isValid = PushClient.verifyInitParams(context, clientId);
        if (isValid) {
            if (TextUtils.isEmpty((CharSequence)webApiPort) || TextUtils.isEmpty((CharSequence)webApiIp) || TextUtils.isEmpty((CharSequence)type)) {
                webApiIp = ConfigurationUtils.getIpPortType(context, "NPSWebApiServiceIp");
                webApiPort = ConfigurationUtils.getIpPortType(context, "NPSWebApiServicePort");
                type = ConfigurationUtils.getIpPortType(context, "NPSWebApiServiceType");
            }
            SharedPreUtils.savaPushConfig(context, webApiIp, webApiPort, type);
            SharedPreUtils.savaPushClientId(context, clientId);
            return NPCManager.initNPC(context);
        }
        LogHelper.getHelper().w("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53c2\u6570\u65e0\u6548");
        return 30012;
    }

    public static int subTopic(Context context, String topic, int type) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        return PushClient.subTopic(context, topics, type);
    }

    @Deprecated
    public static int subTopic(Context context, String topic, IObtainMsgCallBack cb, int type) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        return PushClient.subTopic(context, topics, type);
    }

    @Deprecated
    public static int subTopic(Context context, List<String> topics, IObtainMsgCallBack cb, int type) {
        return PushClient.subTopic(context, topics, type);
    }

    public static int subTopic(Context context, List<String> topics, int type) {
        boolean isValid = PushClient.verifyTopicsParams(context, topics);
        if (isValid) {
            HashSet<String> topicSet = new HashSet<String>();
            List<String> tpcs = SharedPreUtils.getPushTopics(context);
            topicSet.addAll(tpcs);
            topicSet.addAll(topics);
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            map.put(context.getPackageName(), topicSet);
            SharedPreUtils.commitSharedPreSet(context, "TOPIC_HIS", map);
            for (String topic : topics) {
                ProcessNotifyManager.lastGetMsgTimeMillis.put(topic, 0L);
            }
            if (!PushClient.getPushState(context)) {
                LogHelper.getHelper().i("This push is closed by you ");
                return 30023;
            }
            return NPCManager.subscribeTopic(topics, context.getPackageName(), context);
        }
        LogHelper.getHelper().w("\u8ba2\u9605\u5931\u8d25\uff0c\u53c2\u6570\u65e0\u6548");
        return 30022;
    }

    public static int unsubscribe(Context context, String topic, String category) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        return PushClient.unsubscribe(context, topics, category);
    }

    public static int unsubscribe(Context context, List<String> topics, String category) {
        if (PushClient.verifyTopicsParams(context, topics)) {
            NPCManager.unsubscribeTopic(topics, context.getPackageName(), context);
            List<Object> tpcs = new ArrayList();
            tpcs = SharedPreUtils.getPushTopics(context);
            for (String topic : topics) {
                tpcs.remove(topic);
            }
            HashSet<Object> topicSet = new HashSet<Object>();
            topicSet.addAll(tpcs);
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            map.put(context.getPackageName(), topicSet);
            SharedPreUtils.commitSharedPreSet(context, "TOPIC_HIS", map);
            return 30030;
        }
        return 30032;
    }

    public static int release(Context ctx) {
        boolean isValid = false;
        isValid = PushClient.verifyReleaseParams(ctx);
        if (isValid) {
            PushClient.unRegisterPush(ctx);
            return 30040;
        }
        LogHelper.getHelper().w("\u91ca\u653e\u8ba2\u9605\u5931\u8d25\uff0c\u53c2\u6570\u65e0\u6548");
        return 30100;
    }

    private static void unRegisterPush(Context context) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add("UNREGISTER_PUSH");
        NPCManager.closePush(context);
        NPCManager.unsubscribeTopic(topics, context.getPackageName(), context);
        SharedPreUtils.clearSharedPre(context, "INIT_DEVID");
        SharedPreUtils.clearSharedPre(context, "TOPIC_HIS");
    }

    public static int startPush(Context context) {
        if (context == null) {
            return 30100;
        }
        SharedPreUtils.savaPushState(context, 0);
        List<String> topics = SharedPreUtils.getPushTopics(context);
        if (topics.size() != 0) {
            NPCManager.subscribeTopic(topics, context.getPackageName(), context);
            return 30050;
        }
        return 30052;
    }

    public static int stopPush(Context context) {
        if (context == null) {
            return 30100;
        }
        SharedPreUtils.savaPushState(context, -1);
        ArrayList<String> topics = new ArrayList<String>();
        topics.add("UNREGISTER_PUSH");
        NPCManager.unsubscribeTopic(topics, context.getPackageName(), context);
        return 30060;
    }

    public static boolean getPushState(Context context) {
        if (context == null) {
            return false;
        }
        int state = SharedPreUtils.getPushState(context);
        return state == 0;
    }

    public static String getPushClientId(Context context) {
        if (context == null) {
            return "-1";
        }
        return SharedPreUtils.getPushClientId(context);
    }

    public static List<String> getPushTopic(Context context) {
        if (context == null) {
            return null;
        }
        return SharedPreUtils.getPushTopics(context);
    }

    public static void checkPushOnline(Context context) {
        if (context == null) {
            return;
        }
        NPCManager.checkNpcOnline(context);
    }

    private static boolean verifyInitParams(Context context, String devId) {
        if (context == null || devId == null) {
            return false;
        }
        String regex = "^[/\\w]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(devId);
        return matcher.matches();
    }

    private static boolean verifyTopicsParams(Context context, List<String> topics) {
        String regex = "^[/\\w]+$";
        Pattern pattern = Pattern.compile(regex);
        if (context == null) {
            return false;
        }
        if (topics == null) {
            return false;
        }
        if (topics.size() == 0) {
            return false;
        }
        String clientId = SharedPreUtils.getPushClientId(context);
        if (clientId.equals("0")) {
            return false;
        }
        for (String str : topics) {
            if (TextUtils.isEmpty((CharSequence)str) || !str.contains(clientId + "/")) {
                return false;
            }
            Matcher matcher = pattern.matcher(str);
            if (matcher.matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyReleaseParams(Context context) {
        return context != null;
    }
}

