/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.http;

import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonIOException;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.pushsdk.bean.GetMosquittoResult;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.http.bean.ResponseBean;
import com.xdja.pushsdk.http.bean.ServiceException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpHelper {
    private final int timeout = 10000;
    private final String CHARACTER_MODE = "UTF-8";
    private String url = null;
    private Gson gson;
    private final ResponseHandler<ResponseBean> handler = new ResponseHandler<ResponseBean>(){

        public ResponseBean handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                if (statusLine.getStatusCode() == 404) {
                    throw new RuntimeException("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728");
                }
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                throw new RuntimeException("\u54cd\u5e94\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55\u5185\u5bb9");
            }
            InputStreamReader reader = new InputStreamReader(entity.getContent(), "UTF-8");
            try {
                return HttpHelper.this.gson.fromJson((Reader)reader, ResponseBean.class);
            }
            catch (JsonSyntaxException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    };
    private final ResponseHandler<GetMosquittoResult> handler_get = new ResponseHandler<GetMosquittoResult>(){

        public GetMosquittoResult handleResponse(HttpResponse httpResponse) throws IOException {
            int ret = httpResponse.getStatusLine().getStatusCode();
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpResponseEntity = httpResponse.getEntity();
                if (httpResponseEntity == null) {
                    throw new RuntimeException("\u54cd\u5e94\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55\u5185\u5bb9");
                }
                String strResult = EntityUtils.toString((HttpEntity)httpResponseEntity, (String)"UTF-8");
                try {
                    return HttpHelper.this.gson.fromJson(strResult, GetMosquittoResult.class);
                }
                catch (JsonSyntaxException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            throw new RuntimeException("\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728");
        }
    };

    public HttpHelper(String url) throws ServiceException {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw ServiceException.create(33566824, "http\u670d\u52a1\u5730\u5740\u4e3a\u7a7a", null);
        }
        this.url = url;
        this.gson = new Gson();
    }

    public ResponseBean request(RequestBean requestBean) throws ServiceException {
        return this.request(requestBean, null);
    }

    public ResponseBean request(RequestBean requestBean, String authorization) throws ServiceException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.url);
        try {
            if (TextUtils.isEmpty((CharSequence)authorization)) {
                post.addHeader("Authorization", authorization);
            }
            HttpParams paramsFortimeout = httpclient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)paramsFortimeout, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)paramsFortimeout, (int)10000);
            String requestJsonStr = this.gson.toJson(requestBean);
            StringEntity sEntity = new StringEntity(requestJsonStr, "UTF-8");
            sEntity.setContentType("application/json");
            StringEntity httpentity = sEntity;
            post.setEntity((HttpEntity)httpentity);
            return (ResponseBean)httpclient.execute((HttpUriRequest)post, this.handler);
        }
        catch (JsonIOException e) {
            throw ServiceException.create(33566820, e.getMessage(), e);
        }
        catch (ClientProtocolException e) {
            throw ServiceException.create(33566821, e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw ServiceException.create(33566822, e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw ServiceException.create(33566823, e.getMessage(), e);
        }
    }

    public GetMosquittoResult get() throws ServiceException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpRequest = new HttpGet(this.url);
        try {
            HttpParams paramsFortimeout = httpclient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)paramsFortimeout, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)paramsFortimeout, (int)10000);
            return (GetMosquittoResult)httpclient.execute((HttpUriRequest)httpRequest, this.handler_get);
        }
        catch (JsonIOException e) {
            throw ServiceException.create(33566820, e.getMessage(), e);
        }
        catch (ClientProtocolException e) {
            throw ServiceException.create(33566821, e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw ServiceException.create(33566822, e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw ServiceException.create(33566823, e.getMessage(), e);
        }
    }
}

