/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.npcs.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.ArrayList;
import java.util.List;

public class NPCManager {
    private static String npcPackage;

    public static boolean isNPCService(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!service.service.getClassName().endsWith("MqttService") || !service.service.getPackageName().equals(context.getPackageName())) continue;
            npcPackage = service.service.getPackageName();
            LogHelper.getHelper().d("NPCS IS EXISTED::  PROCESS::" + service.process);
            return true;
        }
        LogHelper.getHelper().d("NPCS IS INEXISTED");
        return false;
    }

    public static int initNPC(Context context) {
        if (NPCManager.isNPCService(context)) {
            return 30013;
        }
        Intent intent = new Intent();
        intent.setAction("com.xdja.MqttService");
        intent.setPackage(context.getPackageName());
        ComponentName component = null;
        try {
            component = context.startService(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (component != null) {
            LogHelper.getHelper().d("START NPCS");
            return 30010;
        }
        return 30011;
    }

    @SuppressLint(value={"NewApi"})
    public static int subscribeTopic(List<String> topics, String pg, Context context) {
        if (!NPCManager.isNPCService(context)) {
            return 500;
        }
        Intent intent = new Intent();
        intent.setAction("com.xdja.npcs.SUBTOPIC");
        intent.setPackage(npcPackage);
        intent.putStringArrayListExtra("topic", (ArrayList)topics);
        intent.putExtra("pg", pg);
        LogHelper.getHelper().d("subscribeTopic");
        context.sendBroadcast(intent);
        return 30020;
    }

    public static int unsubscribeTopic(List<String> topics, String pg, Context context) {
        if (!NPCManager.isNPCService(context)) {
            return 500;
        }
        Intent intent = new Intent();
        intent.setAction("com.xdja.npcs.UNSUBTOPIC");
        intent.setPackage(npcPackage);
        intent.putStringArrayListExtra("topic", (ArrayList)topics);
        intent.putExtra("pg", pg);
        LogHelper.getHelper().d("unsubscribeTopic");
        context.sendBroadcast(intent);
        return 30030;
    }

    public static int closePush(Context context) {
        if (!NPCManager.isNPCService(context)) {
            return 500;
        }
        Intent intent = new Intent();
        intent.setAction("com.xdja.npcs.PUSHSTOP");
        intent.setPackage(npcPackage);
        LogHelper.getHelper().d("closePush");
        context.sendBroadcast(intent);
        return 30060;
    }

    public static void checkNpcOnline(Context context) {
        Intent in = new Intent();
        in.setAction("com.xdja.mqtt.ping");
        in.setPackage(context.getPackageName());
        context.sendBroadcast(in);
    }
}

