/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.npcs.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.xdja.pushsdk.npc.npcs.util.NPCManager;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.SharedPreUtils;
import java.util.ArrayList;

public class NPCUtilReceiver
extends BroadcastReceiver {
    private final String MQTTS_ACTION = "com.xdja.MqttService";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("com.xdja.npcs.INVITESUB".equals(action)) {
            String npcLivePackage = intent.getStringExtra("pg");
            if (!context.getPackageName().equalsIgnoreCase(npcLivePackage)) {
                return;
            }
            LogHelper.getHelper().d("\u63a5\u6536\u5230\u9080\u8bf7\u6ce8\u518c\u5e7f\u64ad\uff0c\u8fdb\u884c\u6ce8\u518c");
            int pushState = SharedPreUtils.getPushState(context);
            if (pushState != 0) {
                LogHelper.getHelper().d("This push is closed by you   pushState--->>" + pushState);
                return;
            }
            ArrayList topics = (ArrayList)SharedPreUtils.getPushTopics(context);
            if (topics.size() != 0) {
                Intent i = new Intent();
                i.setAction("com.xdja.npcs.SUBTOPIC");
                i.setPackage(npcLivePackage);
                i.putStringArrayListExtra("topic", topics);
                i.putExtra("pg", context.getPackageName());
                LogHelper.getHelper().d("subscribeTopic");
                context.sendBroadcast(i);
            }
        } else if ("android.intent.action.ACTION_POWER_CONNECTED".equals(action) || "android.intent.action.ACTION_POWER_DISCONNECTED".equals(action) || "android.intent.action.USER_PRESENT".equals(action) || "android.intent.action.SCREEN_ON".equals(action)) {
            LogHelper.getHelper().d("\u6536\u5230\u7cfb\u7edf\u5e7f\u64ad\uff0c\u68c0\u6d4b\u662f\u5426\u63a8\u9001\u8fd8\u5728\u8fd0\u884c-->>");
            if (!NPCManager.isNPCService(context)) {
                LogHelper.getHelper().d("\u6536\u5230\u91cd\u542f\u5e7f\u64ad,\u65e0NPCS\u5b58\u5728\uff0c\u91cd\u542f");
                this.reStartNPCS(context);
            } else {
                this.checkPing(context);
            }
        }
    }

    private void reStartNPCS(Context context) {
        Thread startNpcsThread = new Thread(new StartNpcsTask(context));
        startNpcsThread.start();
    }

    private void checkPing(Context context) {
        LogHelper.getHelper().d("\u624b\u52a8ping\u670d\u52a1\u5668");
        Intent in = new Intent();
        in.setPackage(context.getPackageName());
        in.setAction("com.xdja.mqtt.ping");
        context.sendBroadcast(in);
    }

    class StartNpcsTask
    implements Runnable {
        Context context;

        public StartNpcsTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            if (NPCManager.isNPCService(this.context)) {
                LogHelper.getHelper().i("NPCRec:npcs exist, don't restart npcs");
                return;
            }
            LogHelper.getHelper().i("NPCRec:npcs not exist , restart npcs");
            String clientId = SharedPreUtils.getPushClientId(this.context);
            if (clientId.equals("0")) {
                LogHelper.getHelper().i("can't find clientid and can't start pushservice");
                return;
            }
            Intent intent2 = new Intent();
            intent2.setPackage(this.context.getPackageName());
            intent2.setAction("com.xdja.MqttService");
            this.context.startService(intent2);
        }
    }
}

