/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttPingSender;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import com.xdja.pushsdk.npc.service.MqttService;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.NetState;

class AlarmPingSender
implements MqttPingSender {
    static final String TAG = "AlarmPingSender";
    private static final int FAIL_PING_COUNT = 2;
    private static final long MIN_PING_TIME = 120000L;
    private static final long MAX_PING_TIME = 600000L;
    private static final long WANDER_TIME = 60000L;
    private static final long PING_WIFI = 240000L;
    private static final long PING_2G = 120000L;
    private static final long PING_3G = 300000L;
    private static final long PING_4G = 420000L;
    private static long lastPingTime = 300000L;
    private static String netType;
    private static boolean hasBetterAlive;
    private static boolean isWifiState;
    private static int failPingTimes;
    private ClientComms comms;
    private MqttService service;
    private BroadcastReceiver alarmReceiver;
    private AlarmPingSender that;
    private PendingIntent pendingIntent;
    private volatile boolean hasStarted = false;
    private final Object alarmLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastPingTime() {
        Object object = this.alarmLock;
        synchronized (object) {
            if (this.service != null) {
                String netState = NetState.getNetworkType((Context)this.service);
                LogHelper.getHelper().d("NETWORK_TYPE::" + netState);
                if (netState != null) {
                    isWifiState = false;
                    if (netState.equals(netType) && !"WIFI".equals(netState)) {
                        LogHelper.getHelper().i("network type not changed");
                    } else if ("WIFI".equals(netState)) {
                        isWifiState = true;
                        lastPingTime = 240000L;
                    } else if ("2G".equals(netState)) {
                        hasBetterAlive = false;
                        lastPingTime = 120000L;
                    } else if ("3G".equals(netState)) {
                        hasBetterAlive = false;
                        lastPingTime = 300000L;
                    } else if ("4G".equals(netState)) {
                        hasBetterAlive = false;
                        lastPingTime = 420000L;
                    }
                    netType = netState;
                }
            }
            return lastPingTime / 1000L;
        }
    }

    public AlarmPingSender(MqttService service) {
        if (service == null) {
            throw new IllegalArgumentException("Neither service nor client can be null.");
        }
        this.service = service;
        this.that = this;
    }

    @Override
    public void init(ClientComms comms) {
        this.comms = comms;
        this.alarmReceiver = new AlarmReceiver();
    }

    @Override
    public void start() {
        LogHelper.getHelper().i("Register alarm for ping");
        String action = "MqttService.pingSender.noshare" + this.comms.getClient().getClientId();
        this.service.registerReceiver(this.alarmReceiver, new IntentFilter(action));
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.service, (int)0, (Intent)new Intent(action), (int)0x8000000);
        this.schedule(this.comms.getKeepAlive());
        this.hasStarted = true;
    }

    @Override
    public void stop() {
        LogHelper.getHelper().i("Cancel alarm for ping");
        AlarmManager alarmManager = (AlarmManager)this.service.getSystemService("alarm");
        if (this.pendingIntent != null) {
            alarmManager.cancel(this.pendingIntent);
        }
        if (this.hasStarted) {
            this.hasStarted = false;
            try {
                this.service.unregisterReceiver(this.alarmReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        long nextAlarmInMilliseconds = System.currentTimeMillis() + delayInMilliseconds;
        LogHelper.getHelper().d("Schedule Alarm:  " + delayInMilliseconds);
        AlarmManager alarmManager = (AlarmManager)this.service.getSystemService("alarm");
        if (Build.VERSION.SDK_INT >= 23) {
            alarmManager.setExactAndAllowWhileIdle(0, nextAlarmInMilliseconds, this.pendingIntent);
        } else {
            alarmManager.setExact(0, nextAlarmInMilliseconds, this.pendingIntent);
        }
    }

    private long getNextPingTime(long time, boolean status) {
        time = status ? (time += time >= 600000L ? 0L : 60000L) : (time -= time <= 120000L ? 0L : 60000L);
        return time;
    }

    private void resetPingFailParms() {
        failPingTimes = 0;
    }

    private void changeKeepAliveSecs(long keepAliveSecs) {
        LogHelper.getHelper().i("Change keepAliveMillsSec is " + keepAliveSecs);
        this.service.publishMsg(keepAliveSecs / 1000L + "", "@SYS/change/keepalive");
        this.comms.setKeepAliveSecs(keepAliveSecs / 1000L);
    }

    static {
        hasBetterAlive = false;
        isWifiState = false;
        failPingTimes = 0;
    }

    class AlarmReceiver
    extends BroadcastReceiver {
        private PowerManager.WakeLock wakelock;
        private String wakeLockTag;

        AlarmReceiver() {
            this.wakeLockTag = "MqttService.client." + AlarmPingSender.this.that.comms.getClient().getClientId();
        }

        public void onReceive(Context context, Intent intent) {
            if (this.wakelock == null) {
                PowerManager pm = (PowerManager)AlarmPingSender.this.service.getSystemService("power");
                this.wakelock = pm.newWakeLock(1, this.wakeLockTag);
                this.wakelock.setReferenceCounted(false);
            }
            LogHelper.getHelper(AlarmPingSender.TAG).i("Ping To Server");
            IMqttActionListener mqttActionListener = new IMqttActionListener(){

                @Override
                public void onSuccess(IMqttToken asyncActionToken) {
                    AlarmPingSender.this.resetPingFailParms();
                    if (!isWifiState && !hasBetterAlive) {
                        lastPingTime = AlarmPingSender.this.getNextPingTime(lastPingTime, true);
                        if (AlarmPingSender.this.comms.getKeepAlive() != lastPingTime) {
                            AlarmPingSender.this.changeKeepAliveSecs(lastPingTime);
                        }
                    }
                    AlarmPingSender.this.schedule(lastPingTime);
                    if (AlarmReceiver.this.wakelock != null && AlarmReceiver.this.wakelock.isHeld()) {
                        AlarmReceiver.this.wakelock.release();
                        LogHelper.getHelper(AlarmPingSender.TAG).d("Ping Response onSuccess release --wakelock--" + AlarmReceiver.this.wakelock.toString());
                    }
                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    MqttException ex;
                    if (asyncActionToken != null && (ex = asyncActionToken.getException()) != null && 32000 == ex.getReasonCode() && !isWifiState && failPingTimes++ >= 2) {
                        lastPingTime = AlarmPingSender.this.getNextPingTime(lastPingTime, false);
                        hasBetterAlive = true;
                        AlarmPingSender.this.resetPingFailParms();
                    }
                    if (AlarmReceiver.this.wakelock != null && AlarmReceiver.this.wakelock.isHeld()) {
                        AlarmReceiver.this.wakelock.release();
                        LogHelper.getHelper(AlarmPingSender.TAG).d("Ping Response onFailure release --wakelock--" + AlarmReceiver.this.wakelock.toString());
                    }
                }
            };
            this.wakelock.acquire();
            MqttToken token = AlarmPingSender.this.comms.checkForActivity(mqttActionListener);
            if (token == null) {
                LogHelper.getHelper(AlarmPingSender.TAG).d("No ping while quiescing\uff0c did not send ping");
                if (this.wakelock != null && this.wakelock.isHeld()) {
                    this.wakelock.release();
                    LogHelper.getHelper(AlarmPingSender.TAG).d("No ping while quiescing release --wakelock--" + this.wakelock.toString());
                }
                return;
            }
        }
    }
}

